<?php
# @Author: Rainer Imb <consentio>
# @Date:   2020-05-08 02:52:57
# @Email:  imb@consentio.at
# @Project: consentio mccurdy
# @Filename: exporter_lib.php
# @Last modified by:   consentio
# @Last modified time: 2022-11-16T16:19:40+01:00
# @License: GPL 2.0

class exporter_lib {

	public $format = 'xlsx';
	public $rows = false;
	public $captions = false;
	public $query = false;
	public $taint = false;
	public $file = false;
	public $name = false;

	public function __construct(array$form){
		foreach($form as $k=>$v){$this->{$k}=$v;}
		if (!$this->file) {$this->file = 'Export-'.date('Y-m-d--H-i');}
		}

	public function write() {
		switch ($this->format) {
			case 'xml':
				if ($this->rows) {$this->table_xml();}
				elseif ($this->query) {$this->xml();}
				break;
			case 'xls':
				if ($this->rows) {$this->table_xls();}
				elseif ($this->query) {$this->xls();}
				break;
			case 'csv':
				if ($this->rows) {$this->table_csv();}
				elseif ($this->query) {$this->csv();}
				break;
			default:
				if ($this->rows) {$this->table_xlsx();}
				elseif ($this->query) {$this->xlsx();}
				break;
			}
		}

	private function xml() {
		global $db, $html;
		// ExcelWriterXML has already been included
		$xml = new ExcelWriterXML($this->file.'.'.$this->format);
		$xml->docTitle($this->file);
		$xml->docAuthor($html['user']['name']);

		$format1 = $xml->addStyle('normal');
		$format2 = $xml->addStyle('bold');
		$format2->fontBold();

		$sheet = $xml->addSheet($this->name);
		$arg = $db->prepare($this->query);
		$arg->execute($this->taint);
		$i = 1;
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			if ($i == 1) {
				$j = 1;
				foreach ($data as $vk=>$vv) {$sheet->writeString($i,$j,$vk,'bold'); $j++;}
				$i++;
				}
			$j = 1;
			foreach ($data as $vk=>$vv) {$sheet->writeNumber($i,$j,$vv,'normal'); $j++;}
			$i++;
			}
		$xml->sendHeaders();
		$xml->writeData();
		}

	private function table_xml() {
		global $html;
		// ExcelWriterXML has already been included
		$xml = new ExcelWriterXML($this->file.'.'.$this->format);
		$xml->docTitle($this->file);
		$xml->docAuthor($html['user']['name']);

		$format1 = $xml->addStyle('normal');
		$format2 = $xml->addStyle('bold');
		$format2->fontBold();

		$sheet = $xml->addSheet($this->name);

		$i = 1;
		foreach ($this->rows as $row) {
			if ($i == 1) {
				$j = 1;
				foreach ($row as $vk=>$vv) {
					if (in_array($vk, ['rid','actions'])) {}
					elseif(preg_match('/orig_val/', $vk)) {}
					else {$sheet->writeString($i,$j,$vk,'bold'); $j++;}
					}
				$i++;
				}
			$j = 1;
			foreach ($row as $vk=>$vv) {
				if (in_array($vk, ['rid','actions'])) {}
				elseif(preg_match('/orig_val/', $vk)) {}
				else {$sheet->writeNumber($i,$j,$vv,'normal'); $j++;}
				}
			$i++;
			}
		$xml->sendHeaders();
		$xml->writeData();
		}

	private function xls() {
		global $db, $html;
		// SimpleExcel has already been included
		$xls = new Excel($this->file);
		$arg = $db->prepare($this->query);
		$arg->execute($this->taint);
		$i = 1;
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			if ($i == 1) {
				$xls->home();
				foreach ($data as $vk=>$vv) {$xls->label(utf8_decode($vk)); $xls->right();}
				$xls->down();
				$i++;
				}
			$xls->home();
			foreach ($data as $vk=>$vv) {
				if (is_numeric($vv)) {$xls->number(str_replace(',', '.', $vv)); $xls->right();}
				else {$xls->label(utf8_decode($vv)); $xls->right();}
				}
			$xls->down();
			$i++;
			}
		$xls->send();
		}

	private function table_xls() {
			global $db, $html;
			// SimpleExcel has already been included
			$xls = new Excel($this->file);
			$i = 1;
			foreach ($this->rows as $row) {
				foreach ($row as $vk=>$vv) {
					if (in_array($vk, ['rid','actions'])) {unset($row[$vk]);}
					if(preg_match('/orig_val/', $vk)) {unset($row[$vk]);}
					}
				if ($i == 1) {
					$headers = array_keys($row);
					if ($this->captions) {foreach ($headers as $k => $v) {$headers[$k] = $this->captions[$v];}}
					$xls->home();
					foreach ($headers as $vv) {$xls->label(utf8_decode($vv)); $xls->right();}
					$xls->down();
					}
				$values = array_values($row);
				$xls->home();
				foreach ($values as $vv) {$xls->label(utf8_decode(html_entity_decode($vv))); $xls->right();}
				$xls->down();
				$i++;
				}
			$xls->send();
			}

	private function xlsx() {
		global $db, $html;
		// XLSXWriter has already been included
		$xlsx = new XLSXWriter();
		$xlsx->setTitle($this->file);
		$xlsx->setAuthor($html['user']['name']);
		$arg = $db->prepare($this->query);
		$arg->execute($this->taint);
		$i = 1;
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			if ($i == 1) {
				$headers = array_keys($data);
				$xlsx->writeSheetRow($this->name, $headers, ['font-size'=>10, 'font-style'=>'bold']);
				}
			$values = array_values($data);
			$xlsx->writeSheetRow($this->name, $values);
			$i++;
			}
		$this->xlsx_headers();
		$xlsx->writeToStdOut();
		}

	private function table_xlsx() {
		global $html;
		// XLSXWriter has already been included
		$xlsx = new XLSXWriter();
		$xlsx->setTitle($this->file);
		$xlsx->setAuthor($html['user']['name']);

		$i = 1;
		foreach ($this->rows as $row) {
			foreach ($row as $vk=>$vv) {
				if (in_array($vk, ['rid','actions'])) {unset($row[$vk]);}
				if(preg_match('/orig_val/', $vk)) {unset($row[$vk]);}
				}
			if ($i == 1) {
				$headers = array_keys($row);
				if ($this->captions) {
					foreach ($headers as $k => $v) {$headers[$k] = $this->captions[$v];}
					}
				$xlsx->writeSheetRow($this->name, $headers, ['font-size'=>10, 'font-style'=>'bold']);
				$i++;
				}
			$values = array_values($row);
			$xlsx->writeSheetRow($this->name, $values);
			$i++;
			}
		$this->xlsx_headers();
		$xlsx->writeToStdOut();
		}

	private function xlsx_headers() {
		header('Content-disposition: attachment; filename="'.$this->file.'.'.$this->format.'"');
		header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		}

	private function csv() {
		global $db, $html;
		$this->file;
		$this->csv_headers();
		$csv = fopen('php://output', 'w');
		$arg = $db->prepare($this->query);
		$arg->execute($this->taint);
		$i = 1;
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			if ($i == 1) {
				$headers = array_keys($data);
				fputcsv($csv, $headers, ";");
				}
			$values = array_values($data);
			fputcsv($csv, $values, ";");
			$i++;
			}
		fclose($csv);
		}

	private function table_csv() {
		global $html;
		$this->file;
		$this->csv_headers();
		$csv = fopen('php://output', 'w');

		$i = 1;
		foreach ($this->rows as $row) {
			foreach ($row as $vk=>$vv) {
				if (in_array($vk, ['rid','actions'])) {unset($row[$vk]);}
				if(preg_match('/orig_val/', $vk)) {unset($row[$vk]);}
				}
			if ($i == 1) {
				$headers = array_keys($row);
				fputcsv($csv, $headers, ";");
				$i++;
				}
			$values = array_values($row);
			fputcsv($csv, $values, ";");
			$i++;
			}
		fclose($csv);
		}

	private function csv_headers() {
		header('Content-disposition: attachment; filename="'.$this->file.'.'.$this->format.'"');
		header("Content-Type: application/csv");
		}
	}
?>
