<?php
# @Author: Rainer Imb <imb>
# @Date:   2018-05-28 12:21:38
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2023-09-12T14:16:57+02:00
# @License: GPL 2.0

class access {
	private $method = "post";
	private $enctype = "multipart/form-data";
	public $title;
	public $mytitle = false;
	public $skipTitle = false;
	private $name = "table";
	private $action = "index.php";
	public $error = 0;
	public $errno = 0;
	public $content;
	public $scripts;
	public $rid = 0;
	public $stored = array();
	public $table_sums = array();
	public $words;
	public $rows;
	public $primary = "id";
	public $search = array();
	public $table_fields = array();
	private $human = "id";
	private $view = "table";
	private $no_edit = array();
	private $no_del = array();
	public $edit_only = array();
	private $attr_to_set = array();
	private $no_logical = 0;
	private $left = array();
	private $n_to_n = array();
	private $del_n_to_n = array();
	private $table_data = array();
	private $table_defs = array();
	private $filters = array();
	private $orderby = "id";
	private $defsort = "ASC";
	private $q_limit = 50;
	private $q_limit2 = 20;
	private $autocomplete = 1;
	private $novalidate = false;
	private $dontleave = 1;
	private $doloading = 1;
	private $defsize = 60;
	private $maxsize = 40;
	private $sort_select = false;
	private $sort_select_view = false;
	public $remember = true;
	private $track_q = false;
	public $inputs;
	public $myconf;
	public $force_myconf = false;
	private $hidden;
	public $no_cancel = 0;
	public $no_submit = 0;
	private $no_af;
	private $submit = "_store";
	public $button_text;
	public $button_fa = 'save';
	public $button_disabled = false;
	public $button_css = false;
	public $button_before;
	public $button_after;
	public $button_custom_sort;
	private $prefer_new = 0;
	public $script = array();
	public $offsetText;
	private $tile_counter = 0;
	public $captions = array();

	public $feedback;
	public $feedback_level = 'ok';
	public $table_rows = array();
	public $searchform = 1;
	public $sf_size = 9;
	public $label_size = 2;
	public $before_table;
	public $before_form;
	public $in_form;
	public $in_form_before;
	public $after_form;
	public $in_searchform;
	public $in_sortform;
	public $allow_edit = true;
	public $allow_del = true;
	public $allow_box = "del";
	public $custom_box = false;
	public $custom_box_fa = 'cog';
	public $allow_sort = false;
	public $allow_something = false;
	public $add_button = false;
	public $wrap_class = '';
	public $html_in_table = false;
	public $no_action = false;
	public $uploaded_files = array();
	private $sortable = false;
	private $radio_search_select = false;
	private $clause;
	private $q_arr = array();
	private $freebies = array();
	private $template_table = "<div &&&&wrap_class&&&&>\n<table class='table'>\n&&&&content&&&&\n</tbody>\n</table>\n</div>\n";
	//private $template_tiles = "<div class='table row clrfx'>&&&&content&&&&\n</div>\n";
	private $template_tiles = "<ul class='table yo-tiles'>&&&&content&&&&\n</ul>\n";
	private $tr_class = "shade";
	private $no_db = ["ghost", "free", "fieldset", "function", "subform"];
	private $img_types = ['image/gif', 'image/jpeg', 'image/png'];
	private $fieldset_end = "";
	private $order_sign = [];
	private $temp;

	public function __construct(array$form){
		$this->button_text = i18n('save');
		foreach($form as $k=>$v){
			$this->{$k}=$v;
			}
		$this->order_sign = [get_icon('sort', '-'), get_icon('sort-amount-down-red', '<-'), get_icon('sort-amount-up-red', '->')];
		if ($this->html['myurl']) {$this->action = $this->html['myurl'];}
		$this->dir = $this->html['dir'];
		}

	/**
	 * creates input tags of a from
	 * @param array $input the assoc array for datafields
	 */
	public function add_input($input){
		if (isset($this->table)) {$this->input_defs();}
		$i = 0;
    foreach($input as $k=>$v){
			$v['me'] = $k;
			$bubble = bubble($this->myconf.".".$k);
			$v = $this->expand_input($v);
            if (!array_key_exists("value", $v)) {$v['value'] = $v['default'];}
			if ($v['duty'] >= 1) {$v['caption'] .= "<span class='red' title='".i18n('mess_complete')."'>*</span>";}
			if ($v['duty'] == 2) {$v['css_class'] .= " duty";}
			if ($bubble) {$v['caption'] .= $bubble;}
			//else {$v['caption'] .= $this->myconf;}
			if (!$i && !$this->no_af) {$v['af'] = 1;} $i++;
			if ($this->fieldset_end == $k) {$this->inputs .= "</fieldset>\n"; $this->fieldset_end = "";}

			switch ($v['type']) {
				case "text": $this->inputs .= $this->input_text($v); break;
				case "bigtext": $this->inputs .= $this->input_bigtext($v); break;
				case "wysiwyg": $this->inputs .= $this->input_wysiwyg($v); break;
				case "pwd": $this->inputs .= $this->input_pwd($v); break;
				case "number": $this->inputs .= $this->input_number($v); break;
				case "spin": $this->inputs .= $this->input_spin($v); break;
				case "colorpicker": $this->inputs .= $this->input_colorpicker($v); break;
				case "custom": $this->inputs .= $this->input_custom($v); break;
				case "date": $this->inputs .= $this->input_date($v); break;
				case "multicheck": $this->inputs .= $this->input_multicheck($v); break;
				case "multilookup": $this->inputs .= $this->input_multilookup($v); break;
				case "add_tags": $this->inputs .= $this->input_add_tags($v); break;
				case "lookup": $this->inputs .= $this->input_lookup($v); break;
				case "readonly_lookup": $this->inputs .= $this->input_readonly_lookup($v); break;
				case "suggest": $this->inputs .= $this->input_suggest($v); break;
				case "array": $this->inputs .= $this->input_array($v); break;
				case "country": $this->inputs .= $this->input_country($v); break;
				case "radio": $this->inputs .= $this->input_radio($v); break;
				case "readonly": $this->inputs .= $this->input_readonly($v); break;
				case "flag": $this->inputs .= $this->input_flag($v); break;
				case "image": $this->inputs .= $this->input_image($v); break;
				case "link": $this->inputs .= $this->input_link($v); break;
				case "file": $this->inputs .= $this->input_file($v); break;
				case "icons": $this->inputs .= $this->input_icons($v); break;
				case "free":
				case "hidden": $this->hidden .= $this->input_hidden($v); break;
				case "fieldset": $this->inputs .= $this->start_fieldset($v); break;
				case "subform": $this->inputs .= $this->subform($v); break;
				case "function":
				case "ghost":
				case "void": break;
				default: $this->inputs .= $this->input_text($v); break;
				}
			}
		if ($this->fieldset_end == "last") {$this->inputs .= "</fieldset>\n"; $this->fieldset_end = "";}
        }

	/**
	 * table of data
	 * @param array $input the assoc array for datafields
	 */
	public function table($input){
		global $db;
		$th = [];
		$toggle = '';
		$this->words = param('_w') ? clean_var(param('_w'), "w") : "";
		$this->offset = param('_o') ? clean_var(param('_o'), "n") : 0;
		$this->q_limit = param('_hl') ? clean_var(param('_hl'), "n") : $this->q_limit;
		$this->query = "SELECT";
		if (!in_array($this->primary, $this->table_fields)) {$this->query .= " `{$this->primary}`,";}
		$table = "";
		if ($this->no_action == false) {array_push($th, [i18n("action"), "", "n"]);}
		foreach($input as $a=>$v){
			$v = $input[$a];
			$v['me'] = $a;
			$v = $this->expand_input($v);
			$input[$a] = $v;
			}
		foreach($this->table_fields as $a){
			$v = $input[$a];
			$c = $v['abbr'] ? $v['abbr'] : $v['caption'];
			if (!in_array($v['type'], $this->no_db)) {
				if ($v['type'] == 'sort' and !$v['do']) {$v['type'] = 'text';}
				if (!$v['skip']) {array_push($th, [$c, $v['me'], $v['type']]);}
				$this->query .= " `$a`,";
				}
			elseif ($v['type'] == "function") {array_push($th, [$c, $v['me'], $v['type']]);}
			}
		$this->query = preg_replace("/\,$/", "", $this->query);
		$this->taint = array();
		$this->searching($input);
		$arg = $db->prepare($this->query);
		$arg->execute($this->taint);
		$count = $arg->rowCount();
		$this->rows = $count;
		if (!$count) {
			$err = $arg->errorInfo();
			$error = array_key_exists(2, $err) ? "<p class='red'>$err[2]</p>" : "";
			$table = "<p>".i18n("mess_no_entry")."</p>\n$error\n";
			}
		else {
			$this->offsets($count);
			if ($this->view == "table") {
				$table .= htmltag('thead', 'id="th'.gen_tan(5).'" data-sticky="true"', $this->getTH($th));
				$table .= "<tbody>\n";
				}
			else {
				if ($this->allow_box or $this->custom_box) {
					$alt = i18n('toggle_selection');
					$sign = get_icon('far-check-square red', $alt)."&nbsp;$alt";
					$toggle = htmltag('p', 'data-app="checkBoxControll"', "<br />$sign");
					}
				}
			$arg = $db->prepare($this->query);
			$arg->execute($this->taint);
			$i = 0;

			while ($result = $arg->fetch(PDO::FETCH_ASSOC)) {
				$td = array();
				$css = array();
				$pairs = array();
				$id = $result[$this->primary];
				$this->temp = $result;
				$pairs['rid'] = $id;
				if ($this->no_action == false) {
					$ac = $this->actions($id,$i);
					array_push($td, $ac); $i++;
					array_push($css, '-');
					$pairs['actions'] = $ac;
					}
				foreach($this->table_fields as $a){
					$v = $input[$a];
					$val = array_key_exists($a, $result) ? $result[$a] : "";
					$orig_val = $val;
					$entval = $val ? htmlentities($val) : '';
					switch ($v['type']) {
						case "image": $val = $val ? get_thumb($val, "", $v['prev_dir'], $v['data_attr'], $val, $v['nocache']) : ''; break;
						case "image_assistant": $val = $this->get_image_load($val); break;
						case "readonly_lookup":
						case "lookup": $val = $this->get_lookup($v, $val); break;
						case "multicheck":
						case "multilookup":
						case "add_tags": $val = $this->get_multi_lookup_values($v, $val); break;
						case "country": $val = $this->get_country($v, $val); break;
						case "text": list($val, $title) = str_eclipse($entval, $this->maxsize); break;
						case "bigtext": $val = str_eclipse_with($entval, $this->words, $this->maxsize); break;
						case "wysiwyg":
							if (!$this->html_in_table) {$val = str_eclipse_with(co_strip_tags($val), $this->words, $this->maxsize);}
							break;
						case "flag": $val = $this->get_flag($v, $val, $id); break;
						case "colorpicker": $val = $this->get_color($v, $val, $id); break;
						case "sort": $val = $this->get_sort($v, $val, $id); break;
						case "custom": $val = $this->get_custom($v, $val); break;
						case "function": $val = $this->get_function_value($v); break;
						case "icons":
						case "radio":
						case "array": $val = $this->get_array($v, $val); break;
						}
					if (array_key_exists("pattern", $v)) {$val = sprintf($v['pattern'], $val);}
					if ($a == $this->human) {$v['css_td'] = 'human';}
					if (is_numeric($val) && $v['extra'] == 'color') {$v['css_td'] = $val >= 0 ? 'green': 'red';}
					if (array_key_exists("smart", $v)) {
						$t = array_key_exists("smart_table", $v) ? $v['smart_table'] : $this->table;
						$c = base64_encode($t."|".$v['me']."|".$id);
						$val = htmltag('span', "data-smart=\"$c\"", $val);
						$this->script['smart'] = $v['size'];
						}
					if ($v['extra'] == "url") {
						$link = preg_match('/^https?:|^\/\/?/', $val) ?  $val : "http://".$val;
						$val = htmltag('a', "href=\"$link\" target=\"_blank\"", $val);
						}

					if (!$v['skip']) {
						array_push($td, $val);
						array_push($css, $v['css_td']);
						}
					$pairs[$a] = $val;
					if ($val != $orig_val) {$pairs[$a."_orig_val"] = $orig_val; $this->temp[$a] = $val; $this->temp[$a."_orig_val"] = $orig_val;}
					if (in_array($a, array_keys($this->table_sums))) {$this->table_sums[$a] += $val;}
					}
				if ($this->view == "table") {$table .= $this->getTD($td, $id, $css);}
				if ($this->view == "tiles") {$table .= $this->getTile($td,$th);}
				// score of fulltext
				if (array_key_exists('score', $result))	{$pairs['score'] = $result['score'];}
				array_push($this->table_rows, $pairs);
				}
			$template = $this->template_table;
			if ($this->view == "tiles") {$template = $this->template_tiles;}
			if ($this->words) {$table = safe_highlight($table, $this->words);}
			$template = preg_replace("/&&&&wrap_class&&&&/", " class=\"$this->wrap_class\"", $template);
			$table = preg_replace("/&&&&content&&&&/", $table, $template);
			$table = $toggle."\n".$table;
			if ($this->allow_box or $this->sortable or $this->custom_box) {
				$hidden = $this->get_search_params();
				foreach ($this->freebies as $f => $v) {$hidden .= "<input type=\"hidden\" id=\"i".$f."\" name=\"".$f."\" value=\"".$v."\"  />\n";}
				$buttons = "";
				$act = "<button type='submit' name='_set_att' value='1'><i class='far fa-hand-point-up fa-lg'></i> ".i18n('set_att')."</button>&nbsp;";
				$del = "<button type='submit' name='_del_all' value='1'><i class='fas fa-times fa-lg'></i> ".i18n('delete')."</button>&nbsp;";
				$sor = "<button type='submit'  id='btnSort' name='_sortlist' value='1'><i class='fas fa-sort-numeric-down  fa-lg'></i> ".i18n('sort')."</button>";
				if ($this->allow_box == "attr") {$buttons = $act;}
				elseif ($this->allow_box == "del") {$buttons = $del;}
				elseif($this->allow_box == "both") {$buttons = $act."&nbsp;".$del;}
				// some custom feature
				if ($this->custom_box) {$buttons = "<button type='submit' name='_$this->custom_box' value='1'><i class='far fa-$this->custom_box_fa fa-lg'></i> ".i18n($this->custom_box)."</button>&nbsp;".$buttons;}
				if ($this->sortable) {
					if ($this->button_custom_sort) {$sor = $this->button_custom_sort;}
					$buttons .= "&nbsp;".$sor;
					$buttons .= $this->in_sortform;
					}
				if ($this->add_button) {$buttons .= $this->add_button;}
				$table = "<form action='$this->action' id='i$this->name' name='$this->name' method='$this->method' enctype='$this->enctype'>
				$hidden
				<div class='additional_menu'>
				$buttons
				</div>
				$table
				</form>";
				}
			if ($this->sortable) {$table = $this->sort_srcipts($table);}
			$table = $this->offsetText.$table;
			if ($count > 10) {$table .= $this->offsetText;}
			}
		$this->add_script();
		$table = "$this->before_table\n".$this->searchform.$table;
		$end = microtime(true);
		$time = sprintf('%0.4f ms', 1000*($end-$_SERVER["REQUEST_TIME_FLOAT"]));
		if ($time > 1000) {$time = sprintf('%0.4f s', $end-$_SERVER["REQUEST_TIME_FLOAT"]);}
		$table .= "<p class='small'>$time</p>";
		return $this->html_out($table);
		}

	public function push_data($data) {
		$this->table_data = $data;
		}

	public function data_table($input) {
		$this->offset = param('_o') ? clean_var(param('_o'), "n") : 0;
		$this->query = ''; // dummy
		$th = array();
		$filters = array();
		foreach ($this->filters as $f) {
			$val = clean_var(param($f), "l");
			if ($val) {$filters[$f] = $val;}
			}
		$this->q_arr = ["_sb" => $this->defsort, "_ob" => $this->orderby, "_o" => 0];
		foreach ($filters as $f => $v) {$this->q_arr[$f] = $v;}
		foreach($this->table_fields as $a){
			$v = $input[$a];
			$v['me'] = $a;
			$v = $this->expand_input($v);
			$c = $v['abbr'] ? $v['abbr'] : $v['caption'];
			array_push($th, [$c, $v['me'], $v['type']]);
			$input[$a] = $v;
			}
		$table = "";
		$count = count($this->table_data);
		$this->offsets($count);
		if ($this->view == "table") {
			$table .= htmltag('thead', 'id="th'.gen_tan(5).'" data-sticky="true"', $this->getTH($th));
			$table .= "<tbody>\n";
			}
		$i = 0;
		$limit = $this->offset+$this->q_limit;
		foreach ($this->table_data as $k=>$row) {
			$td = array();
			$css = array();
			if ($i >= $this->offset) {
				foreach ($row as $a=>$val) {
					array_push($td, $val);
					$c = array_key_exists($a, $input) ? $input[$a]['css_td'] : '';
					array_push($css, $c);
					}
				if ($this->view == "table") {$table .= $this->getTD($td, $i, $css);}
				if ($this->view == "tiles") {$table .= $this->getTile($td,$th);}
				}
			$i++;
			if ($i >= $limit) {break;}
			}

		$this->add_script();
		$template = $this->template_table;
		if ($this->view == "tiles") {$template = $this->template_tiles;}
		$template = preg_replace("/&&&&wrap_class&&&&/", " class=\"$this->wrap_class\"", $template);
		$table = preg_replace("/&&&&content&&&&/", $table, $template);
		if ($this->allow_box) {
			$hidden = $this->get_search_params('l');
			foreach ($this->freebies as $f => $v) {$hidden .= "<input type=\"hidden\" id=\"i".$f."\" name=\"".$f."\" value=\"".$v."\"  />\n";}
			$buttons = "";
			$act = "<button type='submit' name='_set_att' value='1'><i class='far fa-hand-point-up fa-lg'></i> ".i18n('set_att')."</button>&nbsp;";
			$del = "<button type='submit' name='_del_all' value='1'><i class='fas fa-times fa-lg'></i> ".i18n('delete')."</button>&nbsp;";
			if ($this->allow_box == "attr") {$buttons = $act;}
			elseif ($this->allow_box == "del") {$buttons = $del;}
			elseif($this->allow_box == "both") {$buttons = $act."&nbsp;".$del;}
			$table = "<form action='$this->action' id='i$this->name' name='$this->name' method='$this->method' enctype='$this->enctype'>
			$hidden
			<div class='additional_menu'>
			$buttons
			</div>
			$table
			</form>";
			}
		$table = $this->offsetText.$table;
		if ($this->before_table) {$table = $this->before_table."\n".$table;}
		return $this->html_out($table);
		}

	/**
	 * set value as defined in $input
	 * @param array $input the assoc array for datafields
	 */
	public function data_ref($input) {
		foreach ($input as $k=>$v){
			$v['me'] = $k;
			$v = $this->expand_input($v);
			switch ($v['type']) {
				case "flag":
					if ($v['value']) {$v['value'] =	"&nbsp;".get_icon('check-green', i18n('yes'));}
					break;
				case  "image":
					if ($v['value']) {$v['orig_val'] = $v['value']; $v['value'] = get_thumb($v['value'], $k, 'square');}
					break;
				case "array":
				case "radio":
					if ($v['value']) {
						$v['orig_val'] = $v['value'];
						$v['value'] = $this->get_array($v, $v['value']);
						}
					break;
				case "readonly_lookup":
				case "lookup":
					if ($v['value']) {
						$v['orig_val'] = $v['value'];
						$v['value'] = $this->get_lookup($v, $v['value']);
						}
					break;
				case "multicheck":
				case "multilookup":
				case "add_tags": $v['value'] = $this->get_multi_lookup_values($v, $v['value']); break;
				case "country":
					if ($v['value']) {
						$v['orig_val'] = $v['value'];
						$v['value'] = $this->get_country($v, $v['value']);
						}
					break;
				}
			$input[$k] = $v;
			}
		return ($input);
		}

	/**
	 * simple preview of data
	 * @param array $input the assoc array for datafields
	 * @return string html table with value pairs
	 */
	public function preview($input) {
		$input = $this->data_ref($input);
		$mycontent = "<table class='table preview'>\n";
		foreach ($input as $k=>$v){
			$value = $v['value'] ? $v['value'] : "&nbsp;";
			$mycontent .= "\t<tr><th>{$v['caption']}</th><td>$value</td></tr>\n";
			}
		$mycontent .= "</table>\n";
		return ($mycontent);
		}


	/**
	 * transforms $input to parsable data
	 * @param array $input the assoc array for datafields
	 * @return array ready to parse a view
	 */
	public function parsable_data($input) {
		$input = $this->data_ref($input);
		$out = array();
		foreach ($input as $k=>$v){
			$out[$k] = $v['value'] ? $v['value'] : "";
			if(array_key_exists('orig_val', $v)) {$out[$k.'_orig_val'] = $v['orig_val'];}
			$out[$k.'_capt'] = $v['caption'];
			}
		return ($out);
		}

	/**
	 * transforms $input to a text
	 * @param array $input the assoc array for datafields
	 * @return string text with value pairs
	 */
	public function input2text($input) {
		$text = "---\n";
		foreach ($input as $k=>$v){
			if ($v['value']) {
				if (is_array($v['value'])) {$v['value'] = implode(', ', $v['value']);}
				$v['value'] = html2plain($v['value']);
				$text .= "{$v['caption']}: {$v['value']}\n";
				}
			}
		$text .= "---\n";
		return ($text);
		}

	/**
	 * sort a table
	 */
	public function sort_list() {
		global $db;
		foreach ($_POST as $k=>$v) {
			if (substr($k, 0, 4) == "sort"){
				$id = clean_var(preg_replace("/sort/", "", $k), "n");
				$arg = $db->prepare("UPDATE `{$this->table}` SET sort= ? WHERE id= ?");
				$arg->execute(array($v, $id));
				}
			}
		# no error!?
		$this->html['popup'] = i18n('mess_sort');
		$this->html['feedback_level'] = $this->feedback_level;
		}

	/**
	 * get values of all records of $rid
	 * @param array $input the assoc array for datafields
	 * @return array assoc array of data
	 */
	public function get_multiple_values($input) {
		$records = array();
		$save_rid = $this->rid;
		if (is_array($this->rid)) {$ids = $this->rid;}
		else {$ids[0] = $this->rid;}
		foreach($ids as $v) {
			$this->rid = $v;
			$all = $this->get_value($input);
			$row = array($this->primary => $v);
			foreach (array_keys($all) as $k=>$v) {
				$row[$v] = isset($all[$v]['value']) ? $all[$v]['value'] : '';
				}
			array_push($records, $row);
			}
		$this->rid = $save_rid;
		return $records;
		}

	/**
	 * get values of one record
	 * @param array $input the assoc array for datafields
	 * @return array assoc array of data
	 */
	public function get_value($input) {
		global $db;
		$query = "SELECT";
		foreach($input as $k=>$v){
			if (!in_array($v['type'], $this->no_db)) {
				$t = isset($v['table']) ? $v['table'] : 0;
				if ($t) {$query .= " `{$this->left[$v['table']-1]['table']}`.`$k`,";}
				else {$query .= " `$this->table`.`$k`,";}
				}
			}
		$query = preg_replace("/\,$/", "", $query);
		$query .= " FROM `$this->table`";
		$join = '';
		foreach ($this->left as $k=>$v) {
			$join .= " LEFT JOIN `{$v['table']}` ON `$this->table`.`$this->primary` = `{$v['table']}`.`{$v['foreign']}`";
			}
		if ($join) {$query .= $join;}
		$query .= " WHERE `$this->table`.`{$this->primary}` = ?;";
		$rid = clean_var($this->rid, "w");
		$human = '';
		$arg = $db->prepare($query);
		$arg->execute(array($rid));
		if (!$arg->rowCount()) {$this->error = 1; $this->feedback = $this->rid." ".$query." ".i18n("no_result");}
		else {
			$result = $arg->fetch(PDO::FETCH_ASSOC);
			$this->temp = $result;
			foreach($result as $k=>$v) {
				if (!array_key_exists("value", $input[$k])) {
					$input[$k]['value'] = $v ? htmlentities($v) : '';
					if ($k == $this->human) {$human = "<i>&raquo;".$input[$k]['value']."&laquo;</i>";}
					}
				}
			}
		$this->query = $query;
		$this->mytitle = i18n('entry')." ".i18n('no_abbr')." $rid $human";
		return ($input);
		}

	/**
	 * get values of settings (pair of key and value)
	 * @param array $input the assoc array for datafields
	 * @return array $input with value
	 */
	public function get_settings_value($input, $all = true) {
		global $db;
		$clause = "";
		foreach($input as $k=>$v){
			if ($v['type'] == 'free') {$clause .= " `$k` = '{$input[$k]['default']}' AND";}
			}
		$clause = preg_replace("/AND$/", "", $clause);
		$query = "SELECT `key`, `value` FROM `$this->table` WHERE $clause";
		$arg = $db->prepare($query);
		$arg->execute();
		while ($result = $arg->fetch(PDO::FETCH_ASSOC)) {
			if ($all || array_key_exists($result['key'],$input))  {
				$input[$result['key']]['value'] = $result['value'] ? htmlentities($result['value']) : $result['value'];
				}
			}
		return ($input);
		}

	/**
	 * set a value to selected records
	 * @param array $input the assoc array for datafields
	 * @return number affected records
	 */
	public function set_attribute($inputs) {
		global $db;
		$feedback = "";
		$count = 0;
		foreach ($this->attr_to_set as $v) {
			if (param("_set_attr_$v")) {
				$inputs[$v]['me'] = $v;
				$inputs[$v] = $this->expand_input($inputs[$v]);
				$names = clean_var(param('_names'), "w");
				$val = clean_var(param($v), "w");
				if (!$val and $inputs[$v]['duty'] == 1) {
					$feedback .= i18n('op_not_pos');
					}
				else {
					$ids = array();
					if (is_array($this->rid)) {$ids = $this->rid;}
					else {$ids[0] = $this->rid;}
					foreach($ids as $i) {
						$i = clean_var($i, "n");
						$query = "UPDATE `$this->table` SET `$v` = '$val' WHERE `{$this->primary}` = ?;";
						$arg = $db->prepare($query);
						$arg->execute(array($i));
						$count += $arg->RowCount();
						}
					$feedback .= "$names:<br /> {$inputs[$v]['caption']} ".i18n('mess_updated');
					}
				}
			}
		$this->html['popup'] = $feedback;
		$this->html['feedback_level'] = $this->feedback_level;
		return $count;
		}


	/**
	 * get parameters from form
	 * @param array $input the assoc array for datafields
	 * @return array $input with value
	 */
	public function get_params($input) {
		if (isset($this->table)) {$this->input_defs();}
		foreach($input as $k=>$v){
			$v['me'] = $k;
			$v = $this->expand_input($v);
			if (param($k)) {$v['value'] = param($k);}
			// 0 means 0
			elseif (param($k) === '0') {$v['value'] = '0';}
			// there must be any content
			else {
				if ($v['type'] != 'function') {$v['value'] = $v['empty'];}
				if ($v['duty'] > 0) {
					switch($v['type']) {
						case "image":
						if (!$_FILES["file$k"]['size']) {
							$v['duty'] = 2;
							$this->error = 1;
							$this->feedback .= " {$v['caption']} {$_FILES["file$k"]['error']},";
							}
						elseif (!in_array($_FILES["file$k"]["type"], $this->img_types)) {
							$v['duty'] = 2;
							$v['value'] = "";
							$this->error = 1;
							$this->feedback .= " {$v['caption']}: ".i18n('no_img_mime');
							}
						break;
						case 'file':
						if (!$_FILES["file$k"]['size']) {
							$v['duty'] = 2;
							$this->error = 1;
							$this->feedback .= " {$v['caption']} {$_FILES["file$k"]['error']},";
							}
						break;
						case 'subform':
							$c = $this->check_sub($v);
							if ($c == 0) {
								$v['duty'] = 2;
								$this->error = 1;
								$this->feedback .= " {$v['caption']},";
								}
						break;
						default:
							$v['duty'] = 2;
							$this->error = 1;
							$this->feedback .= " {$v['caption']},";
							}
						}
					}

			// there must be a special content
			switch($v['type']) {
				case "pwd":
					if (array_key_exists('repeat', $v)) {
						if (param($k) != param("cc$k")) {
							$v['duty'] = 2;
							$v['value'] = "";
							$this->error = 1;
							$this->feedback .= " {$v['caption']}: ".i18n('pwd_twice').',';
							}
						}
					break;
				case "email":
					if ($v['value'] and filter_var($v['value'], FILTER_VALIDATE_EMAIL) === false) {
						$v['duty'] = 2;
						$this->error = 1;
						$this->feedback .= " {$v['caption']}: ".i18n('incorrect_data').',';
						}
					break;
				case 'lookup':
					if (!$v['value'] && param('human'.$k)) {$v['value'] = param('human'.$k);}
					break;
				// spammers use to have more text than the input-field allows
				case "text":
					if (array_key_exists('max_size', $v) && $v['value']){
						if ($v['max_size'] && strlen($v['value']) > $v['max_size']) {
							//echo strlen($v['value']).' '.$v['max_size'];
							$v['duty'] = 2;
							$this->error = 1;
							$this->feedback .= i18n('incorrect_data');
							}
						}
					break;
				}
			$input[$k] = $v;
			}
		if ($this->error) {$this->feedback = i18n('mess_duty')."<br />".preg_replace("/\,$/", "", $this->feedback);}
		return ($input);
		}

	/**
	 * get the lookup value (1:1)
	 * @param1 array assoc array one datafield
	 * @param2 string orignal value
	 * @return string lookup value
	 */
	public function get_lookup($field, $val) {
		global $db;
		$df = array_key_exists('tval', $field) ? $field['tval'] : $field['lval'];
		if (is_array($df)) {
			$f = '';
			foreach ($df as $d) {$f .= "`$d`, ' ',";}
			$f = preg_replace("/, ' ',$/", '', $f);
			$cdf = "CONCAT($f) AS `$df[0]`";
			$df = $df[0];
			}
		else {$cdf = "`$df`";}
		$query = "SELECT $cdf FROM `{$field['ltable']}` WHERE `{$field['lid']}` = ? LIMIT 1";
		$arg = $db->prepare($query);
		$arg->execute(array($val));
		$val = $arg->fetch(PDO::FETCH_ASSOC);
		if ($val) {return $val[$df];}
		else {return '';}
		}

	/**
	 * get the lookup values (1:n)
	 * @param1 array assoc array one datafield
	 * @return array id=>value
	 */
	public function get_multi_lookup($field) {
		global $db;
		$out = array();
		if (is_array($field['value'])) {$field['value'] = "'".implode("','", $field['value'])."'";}
		$df = array_key_exists('tval', $field) ? $field['tval'] : $field['lval'];
		$query = "SELECT `{$field['lid']}`, `$df` FROM `{$field['ltable']}` WHERE `{$field['lid']}` IN ({$field['value']});";
		$arg = $db->prepare($query);
		$arg->execute();
		while ($val = $arg->fetch(PDO::FETCH_ASSOC)) {
			$out[$val[$field['lid']]] = $val[$df];
			}
		return $out;
		}

	/**
	 * get the lookup values (1:n)
	 * @param1 array assoc array one datafield
	 * @return string the value
	 */
	public function get_multi_lookup_values($field, $val) {
		$vals = array();
		if ($val) {
			$field['value'] = explode(',', $val);
			$vals = array_values($this->get_multi_lookup($field));
			}
		return implode(', ', $vals);
		}

	/**
	 * get the display value of an array as defined
	 * @param1 array assoc array one datafield
	 * @param2 string orignal value
	 * @return string the value
	 */
	public function get_array($field, $val) {
		$dir = "/co_icons";
		$icon = "";
		$value = $val;

		if ($field['type'] == "icons") {
			$dir = $field['icon_dir'];
			$icon = $value;
			}
		else {
			if (!array_key_exists("raw", $field)) {
				$value = $field['extra'][$val-1];
				if (array_key_exists("view", $field)) {$value = $field['view'][$val-1];}
				if (array_key_exists("icons", $field)) {$icon = $field['icons'][$val-1];}
				if (array_key_exists("fontawesome", $field)) {$value = "&nbsp;".get_icon($field['fontawesome'][$val-1], $value);}
				}
			else {
				$k = array_search($value, $field['extra']);
				if (array_key_exists("view", $field)) {$value = $field['view'][$k];}
				if (array_key_exists("icons", $field)) {$icon = $field['icons'][$k];}
				if (array_key_exists("fontawesome", $field)) {$value = "&nbsp;".get_icon($field['fontawesome'][$k], $value)."&nbsp;";}
				}
			}

		if ($icon) {$icon = "&nbsp;<img src='$dir/$icon.png' width='16' height='16' alt='$value' title='$value' class='icon' />";}
		$out = $icon ? $icon : $value;
		return $out;
		}

	/**
	 * get the display value of an array as defined
	 * @param1 array assoc array one datafield
	 * @param2 string orignal value
	 * @param2 string id of record
	 * @return string the value
	 */
	public function get_flag($field, $val, $id) {
		$state = $val ? "checked" : "unchecked";
		$color = $val ? "green" : "ghost";
		$text = $val ? i18n('yes') : i18n('no');
		$out = "&nbsp;<i class=\"fas fa-check fa-lg $color\" title=\"{$field['caption']}: $text\" data-app=\"s_{$field['me']}\" data-val=\"$state-$id\"></i>";
		foreach ($this->no_edit as $k) {
			if ($k == $id) {$out = "&nbsp;<i class=\"fas fa-check fa-lg $color\" title=\"{$field['caption']}: $text\"></i>";}
			}
		if ($field['extra'] != 'noscript') {
			$t = array_key_exists('ftable', $field) ? $field['ftable'] : $this->table;
			$reload = array_key_exists('reload', $field) ? 1 : 0;
			if (!array_key_exists('flag', $this->script)) {$this->script['flag'] = array();}
			if (!array_key_exists($field['me'], $this->script['flag'])) {$this->script['flag'][$field['me']] = "\$(document).ready(function(){\$(\"[data-app='s_{$field['me']}']\").toggleFlag({'t': '".i18n('change_status')."', 'sid':'{$this->html['sid']}', 'action': '$t', 'r': '$reload', 'script': '{$this->action}','f': '{$field['me']}'})});";}
			}
		return $out;
		}

	public function get_color($field, $val, $id) {
		$out = "&nbsp;<i class=\"fas fa-circle fa-lg \" style=\"color:$val\"></i> $val";
		return $out;
		}

	/**
	 * get value of a datafield with custom string or function
	 * @param1 array assoc array one datafield
	 * @param2 string orignal value
	 * @return string the value
	 */
	public function get_custom ($field, $val){
		$out;
		if (function_exists($field['view'])){$out = $field['view']($val, $field['me'], $this->temp);}
		else {$out = preg_replace("/\+\+VALUE\+\+/", $val, $field['view']);}
		return $out;
		}

	/**
	 * get value of a function
	 * @param1 array assoc array one datafield
	 * @return string the value
	 */
	public function get_function_value ($field){
		$in = $field['value'];
		$out = preg_replace_callback("/\{(\w+)\}/", function($m){return '"'.$this->temp[$m[1]].'"';}, $in);
		$out = create_function("", "return (" . $out . ");" );
		return $out();
		}

	/**
	 * get display value of a datafield with iso3166 code
	 * @param1 array assoc array one datafield
	 * @param2 string orignal value
	 * @return string the value
	 */
	public function get_country($field, $val) {
		global $html;
		$countryname = get_country_name($val);
		$icon = get_flag_by_country($val, $countryname);
		$out = $field['abbr'] ? "&nbsp;$icon" : "$icon&nbsp;$countryname";
		if ($field['extra'] == 'no_flag') {$out = $countryname;}
		return $out;
		}

	/**
	 * save a record
	 * @param1 array assoc array one datafield
	 * @return string (new) id of record
	 */
	public function store($input) {
		global $db;
		$taint = array();
		$query = $this->rid == "new" ? "INSERT INTO" : "UPDATE";
		foreach ($this->left as $k=>$v) {
			$this->left[$k]['query'] = $query." `{$v['table']}` SET";
			$this->left[$k]['taint'] = array();
			}
		$query .= " `{$this->table}` SET";
		foreach ($input as $k=>$v) {
			if (!in_array($v['type'], $this->no_db)) {
				if ($v['table']) {$this->left[$v['table']-1]['query'] .= " `$k` = ?,";}
				else {$query .= " `$k` = ?,";}
				$value = $v['value'];
				switch ($v['type']) {
					case "image":
						if (array_key_exists("file$k", $_FILES) and $_FILES["file$k"]['size']) {
							$value = upload($this->dir."/pictures","file$k", 'u');
							scale_image($value);
							$p = array_key_exists('portfolio', $v) ? $v['portfolio'] : 1;
							insert_image_db($value, $this->myconf, $input[$this->human]['value'], $p);
							$this->uploaded_files[$k] = $value; // save new filename
							}
						break;
					case "file":
						if (array_key_exists("file$k", $_FILES) and $_FILES["file$k"]['size']) {
							$dir = $v['dir'] ? $v['dir'] : '';
							if (param('_d')) {$dir =  clean_var(param('_d'), 'w');}
							$value = upload($this->dir."/$dir","file$k", 'u');
							$value = "/$dir/$value";
							$this->uploaded_files[$k] = $value; // save new filename wth directory
							}
						break;
					case "multicheck":
					case "multilookup":
						if ($value) {
							if (!$v['raw']) {$this->n_to_n[$v['ltable']] = $value;}
							$value = implode(',', $value);
							}
						else {array_push($this->del_n_to_n, $v['ltable']);} // maybe we have to delete some entries in sync-table
						break;
					case "add_tags":
						$value = $this->multi_sync($v);
						if ($value) {$this->n_to_n[$v['ltable']] = explode(',', $value);}
						break;
					case "number": $value = preg_replace("/\,/", ".", $value); break;
					case "pwd": $value = $this->pwd_check($v); break;
					}
				if ($v['table']) {array_push($this->left[$v['table']-1]['taint'], $value);}
				else {array_push($taint, $value);}
				$this->stored[$k] = $value;
				}
			}
		$query = preg_replace("/\,$/", "", $query);
		if ($this->rid == "new") {$query .= ";";}
		else {$query .= " WHERE `{$this->primary}` = ?;"; array_push($taint, $this->rid);}
		$arg = $db->prepare($query);
		$arg->execute($taint);
		$err = $arg->errorInfo();
		$error = array_key_exists(2, $err) ? $err[2] : "";
		$this->errno = array_key_exists(1, $err) ? $err[1] : 0;
		//echo $error;
		$this->query = $this->retaint_query($query, $taint);
		if ($this->track_q) {$this->track_query($this->query);}

		$id = 0;
		if ($error) {$this->error = 1; $this->feedback .= " $error"; $this->feedback_level = 'warning';}
		else {
			$id = $this->rid == "new" ? $db->lastInsertId() : $this->rid;
			// save values of left table
			foreach ($this->left as $k=>$v) {
				$q = $this->left[$k]['query'];
				if ($this->rid == "new") {
					$q .= " `{$this->left[$k]['foreign']}` = ?;";
					}
				else {
					$q = preg_replace("/\,$/", "", $q);
					$q .= " WHERE `{$this->left[$k]['foreign']}` = ?;";
					}
				array_push($this->left[$k]['taint'], $id);
				$arg = $db->prepare($q);
				$arg->execute($this->left[$k]['taint']);
				$err = $arg->errorInfo();
				$error = array_key_exists(2, $err) ? $err[2] : "";
				}
			// save or delete values of n:n table
			foreach ($this->n_to_n as $k=>$v) {$this->sync_junction($k, $v, $id);}
			foreach ($this->del_n_to_n as $k) {$this->del_junction($k,$id);}
			if ($error) {$this->error = 1; $this->feedback .= " $error"; $this->feedback_level = 'warning';}
			else {
				if ($this->human == '_rec') {$humid = i18n('entry');}
				else {
					$humid = $input[$this->human]['value'] ? $input[$this->human]['value'] : "#".$id;
					$humid = "\"$humid\"";
					}
				$this->feedback = "$humid ".i18n("mess_stored");
				}
			}

		$this->html['popup'] = $this->feedback;
		$this->html['feedback_level'] = $this->feedback_level;
		return $id;
		}

	/**
	 * save records of settings
	 * @param1 array assoc array one datafield
	 */
	public function store_settings($input) {
		global $db;
		$keys = array();
		$confs = array();
		foreach($input as $k=>$v){
			switch ($v['type']) {
				case 'free': array_push($confs, $k); break;
				case 'fieldset': break;
				case "multicheck":
				case "multilookup":
					if ($input[$k]['value']) {
						if (!$v['raw']) {$this->n_to_n[$v['ltable']] = $input[$k]['value'];}
						$input[$k]['value'] = implode(',', $input[$k]['value']);
						}
					array_push($keys, $k);
					break;
				case "image":
					if (array_key_exists("file$k", $_FILES) and $_FILES["file$k"]['size']) {
						$value = upload($this->dir."/pictures","file$k", 'u');
						scale_image($value);
						$p = array_key_exists('portfolio', $v) ? $v['portfolio'] : 1;
						insert_image_db($value, $this->myconf, $k, $p);
						$input[$k]['value'] = $value;
						}
					array_push($keys, $k);
					break;
				default: array_push($keys, $k);
				}
			}
		$clause = "";
		$append = "";
		foreach ($confs as $c) {
			$clause .= " `$c` = '{$input[$c]['value']}' AND";
			$append .= " `$c` = '{$input[$c]['value']}',";
			}
		$clause = preg_replace("/AND$/", "", $clause);
		$append = preg_replace("/\,$/", "", $append);
		foreach ($keys as $k) {
			$query = "UPDATE `{$this->table}` SET `value` = ? WHERE `key` = ? AND $clause;";
			$value = $input[$k]['value'];
			$arg = $db->prepare("SELECT `id` FROM `{$this->table}` WHERE `key` = ? AND $clause;");
			$arg->execute(array($k));
			if (!$arg->rowCount()) {
				$query = "INSERT INTO `{$this->table}` SET `value` = ?, `key` = ?, $append;";
				}
			$arg = $db->prepare($query);
			$arg->execute(array($value, $k));
			$err = $arg->errorInfo();
			$error = array_key_exists(2, $err) ? $err[2] : "";
			$this->errno = array_key_exists(1, $err) ? $err[1] : 0;
			if ($error) {$this->error = 1; $this->feedback .= " $error";}
			else {$this->feedback = i18n("settings").": ".i18n("mess_stored");}
			}
		}

	/**
	 * deletes a record
	 */
	public function delete() {
		global $db;
		$names = ""; $ids = array();
		if (is_array($this->rid)) {$ids = $this->rid;}
		else {$ids[0] = $this->rid;}
		foreach($ids as $v) {
			$v = clean_var($v, "n");
			$query = "DELETE FROM `$this->table` WHERE `{$this->primary}` = ?;";
			$arg = $db->prepare($query);
			$arg->execute(array($v));
			}
		$err = $arg->errorInfo();
		$error = array_key_exists(2, $err) ? $err[2] : "";
		if ($error) {$this->error = 1; $this->feedback .= " $error";}
		else {$this->feedback = "\"".param('_names')."\" ".i18n("mess_deleted");}
		$this->html['popup'] = $this->feedback;
		$this->html['feedback_level'] = $this->feedback_level;
		foreach ($this->left as $k=>$v) {
			foreach($ids as $l) {
				$l = clean_var($l, "n");
				$query = "DELETE FROM `{$v['table']}` WHERE `{$v['foreign']}` = ?;";
				$arg = $db->prepare($query);
				$arg->execute(array($l));
				}
			}
		}

	/**
	 * ask if we should delete one or more records
	 */
	public function ask() {
		list ($hidden, $names) = $this->get_selection();
		if ($names) {
			$q = preg_replace("/_-\(o\)-_/", "<br />$names<br />", i18n('realy_delete'));
			$form = "
	<form action='$this->action' id='i$this->name' name='$this->name' method='post' enctype='$this->enctype'>
		<input type='hidden' name='_names' value='$names'>
		$hidden
		<p class='red'>$q?</p>
		<div class='buttons'>
		<input type='submit' value='".i18n('cancel')."' class='button' formnovalidate />
		<input type='submit' name='_del' value='".i18n('ok')."' class='button' />
		</div>
	</form>\n";
			$form = say_mess($form, i18n('question'), "question");
			}
		else {$form = say_mess(i18n('no_selection'), i18n('error'), "error");}
		return $this->html_out($form);
		}

	/**
	 * a custom form
	 */
	public function any_form($inputs, $dlg = true, $btn = '_del') {
		$cancel = $this->no_cancel == true ? '' : "<button type='submit' formnovalidate><i class='fas fa-times-circle fa-lg'></i> ".i18n('cancel')."</button>&nbsp;";
		$form = "
<div class='tlform'>
	<form action='$this->action' id='i$this->name' name='$this->name' method='post' enctype='$this->enctype'>
		<input type='hidden' name='sid' value='{$this->html['sid']}' />
		<input type='hidden' name='_id' value='{$this->myconf}' />
		$inputs
		<div class='buttons'>
		$cancel<button type='submit' name='$btn' value='1'><i class='fas fa-check fa-lg'></i>".i18n('ok')."</button>&nbsp;
		</div>
	</form>
</div>\n";
		if ($dlg) {$form = say_mess($form, i18n('question'), "question");}
		return $this->html_out($form);
		}

	/**
	 * calls a form to set some attributes of some records
	 * @param1 array assoc array one datafield
	 */
	public function attr_form($inputs) {
		list ($hidden, $names) = $this->get_selection();
		# free param
		foreach($inputs as $k=>$v){
			if($v['type'] == "free"){
				$val = clean_var(param($k), "w");
				$hidden .= "<input type='hidden' name='$k' value='$val' />";
				}
			}
		if ($names) {
			$content = "
			<p><strong>".count($this->rid)." ".i18n('records')."</strong>: $names</p>";
			$form = "
	<form action='$this->action' name='$this->name' method='post' enctype='$this->enctype'>
		<input type='hidden' name='_names' value='$names' />
		$hidden\n";
			foreach ($this->attr_to_set as $v) {
				$inputs[$v]['me'] = $v;
				$inputs[$v] = $this->expand_input($inputs[$v]);
				$submit = "<div class='buttons'><input type='submit' name='_set_attr_$v' value='".i18n('ok')."' class='button' /></div>";
				$inputs[$v]['value'] = 0;
				$input = "";
				switch ($inputs[$v]['type']) {
					case "suggest": $input .= $this->input_suggest($inputs[$v]); break;
					case "lookup": $input .= $this->input_lookup($inputs[$v]); break;
					case "array": $input .= $this->input_array($inputs[$v]); break;
					case "radio": $input .= $this->input_radio($inputs[$v]); break;
					case "icons": $input .= $this->input_icons($inputs[$v]); break;
					case "country": $input .= $this->input_country($inputs[$v]); break;
					case "flag": $input .= $this->input_flag($inputs[$v]); break;
					case "date": $input .= $this->input_date($inputs[$v]); break;
					default:  $input .= "<p>NO MULTIPLE SETTING FOR ".$v."</p>";
					}
				$content .= "<div class='tlform'>".$form.$input.$submit."\n\t</form>\n\t</div><hr />";
				}
			if ($this->in_form) {$content .= "<div class='tlform'>".$form.$this->in_form."\n\t</form>\n\t</div><hr />";}
			$content .= "<div class='buttons alright'>".$form."<input type='submit'  value='".i18n('cancel')."' class='button' formnovalidate />\n\t</form>\n\t</div>";
			$content = htmltag('h2', '', get_icon('question-circle-blue', '')." ".i18n('set_att')).$content;
			}
		else {$content = say_mess('<p>'.i18n('no_selection')."</p><p class='alright'><a class='as_button' href='{$this->html['myurl']}?sid={$this->html['sid']}&amp;_id={$this->myconf}'>".i18n('ok')."</a></p>", i18n('info'), "info");}
		$this->add_script();
		return $this->html_out($content);
		}

	/**
	 * make a form
	 * @return array assoc array of html
	 */
	public function form() {
		$access = true;
		if (!empty($this->edit_only)) {
			if (!in_array($this->rid, $this->edit_only)) {$access = false;}
			}
		if ($access) {
			if ($this->rid == 'new') {$this->mytitle = i18n('new_entry');}
			$buttons = "<div class='buttons'>";
			$hidden = "\t\t<input type='hidden' name='rid' value='{$this->rid}' />\n";
			if ($this->remember) {$hidden .= $this->get_search_params();}
			else {$hidden .= $this->get_search_params('w', true);}
			if ($this->button_before) {$buttons .= $this->{'button_before'}."&nbsp;";}
			if (!$this->no_cancel) {$buttons .= "<button type='submit' formnovalidate><i class='fas fa-times-circle fa-lg'></i> ".i18n('cancel')."</button>&nbsp;";}
			$autocomplete = $this->autocomplete == "off" ? " autocomplete='off'" : "";
			$novalidate = $this->novalidate == true ? " novalidate" : "";
			if (!$this->no_submit) {
				if ($this->button_text == i18n('next')) {$this->button_fa = 'arrow-circle-right';}
				$css = $this->button_css ? ' class="'.$this->button_css.'"' : '';
				$dea = $this->button_disabled ? ' disabled' : '';
				$buttons .= "<button type='submit' name='{$this->submit}' value='1'$css$dea><i class='fas fa-{$this->button_fa} fa-lg'></i> {$this->button_text}</button>&nbsp;";
				}
			if ($this->button_after) {$buttons .= $this->{'button_after'};}
			$buttons .= "</div>";
			if ($this->feedback) {$this->feedback = "<p class='red'>".$this->feedback."</p>";}
			$title = $this->title ? "<h2>$this->title</h2>" : "";
			$this->mytitle = $this->mytitle ? "<h2>$this->mytitle</h2>" : '';
			if ($this->skipTitle) {$this->mytitle = '';}
			$form = <<<EOL
			$this->before_form
			<div class='tlform'>
			$this->feedback
			$this->mytitle
			<form action='$this->action' id='i$this->name' name='$this->name' method='$this->method' enctype='$this->enctype'$autocomplete$novalidate>
			$hidden
			$this->hidden
			$this->in_form_before
			$this->inputs
			$this->in_form
			$buttons
			</form>
			$this->after_form
			</div>
EOL;
			if ($this->dontleave) {$this->script['dontleave'] = 1;}
			if ($this->doloading) {$this->script['loading_mess'] = 1;}
			$this->add_script();
			}
		else {$form = '<p class="red">'.i18n('access_denied').'</p>';}
		return $this->html_out($form);
		}

##### different types of input-fields #####

	public function input_text($field){
		$af = isset($field['af']) ? " autofocus='autofocus'" : '';
		$max = $field['max_size'] ? " maxlength='{$field['max_size']}'" : '';
		$ph = isset($field['placeholder']) ? " placeholder='{$field['placeholder']}'" : '';
		$required = $field['duty'] ? ' required' : '';
		if (in_array($field['type'], ['sort', 'number'])) {$field['css_class'] .= ' loose ';}
		$emptyccheck = '';
		if (array_key_exists('row2', $field)) {$emptyccheck = $field['row2'] == 'alt' ? ' data-empty="true"' : '';}
		$type = 'text';
		if ($field['extra'] == "url") {$type = 'url';}
		if ($field['extra'] == "email") {$type = 'email';}
		$in = "<input type=\"$type\" class=\"text ".$field['css_class']."\" id=\"i".$field['me']."\" name=\"".$field['me']."\" value=\"".$field['value']."\" size=\"".$field['size']."\"$max$af$ph$required$emptyccheck ".$field['data_attr']."/>&nbsp;".$field['in_body'];
		if ($field['extra'] == "url") {
			$link = preg_match('/^https?:|^\/\/?/', $field['value']) ?  $field['value'] : "http://".$field['value'];
			$in .= "&nbsp;<a href='$link' target='_blank'>".get_icon('preview', i18n('preview'))."</a>";
			}
		elseif ($field['extra'] == "email") {$in .= "&nbsp;<a href='mailto:{$field['value']}'>".get_icon('envelope', i18n('email'))."</a>";}
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_bigtext($field){
		global $codemirror;
		$inline = "";
		if (!array_key_exists("cols", $field)) {$field['cols'] = 52;}
		if (!array_key_exists("rows", $field)) {$field['rows'] = 10;}
		if ($field['max_size']) {$this->script['counter'] = "i{$field['me']}";}
		$max = $field['max_size'] ? " maxlength='{$field['max_size']}'" : '';
		if ($field['max_size']) {$this->script['counter'] = "i{$field['me']}"; $max .= " data-app='counter'";}
		$in = "<textarea id='i{$field['me']}' name='{$field['me']}' cols='{$field['cols']}' rows='{$field['rows']}' class='text {$field['css_class']}'$max>{$field['value']}</textarea>&nbsp;{$field['in_body']}\n";
		if ($field['max_size']) {$this->script['counter'] = "i{$field['me']}";}
		if (array_key_exists("syntax", $field) and $codemirror['path']) {
			$cm = [
				'path'		=> $codemirror['path'],
				'id'		=> "i".$field['me'],
				'syntax'	=> $field['syntax']
				];
			$inline = parse_in('codemirror_inlinescript', $cm);
			$this->scripts .= parse_in('codemirror_script', $cm);
			$this->scripts .= parse_in("codemirror_mode_{$field['syntax']}", $cm);
			$in .= $inline;
			$in = $this->make_row2($field, $in);
			}
		else {$in = $this->make_row($field, $in);}
		return $in;
		}

	public function input_wysiwyg($field){
		if (!array_key_exists("cols", $field)) {$field['cols'] = 80;}
		if (!array_key_exists("rows", $field)) {$field['rows'] = 35;}
		$val = $field['value'];
		$in = "<textarea id='i{$field['me']}' name='{$field['me']}' cols='{$field['cols']}' rows='{$field['rows']}' class='text {$field['css_class']}'>$val</textarea>&nbsp;".$field['in_body'];
		$in = $this->make_row2($field, $in);
		$this->script['rte'] = "i{$field['me']}";
		$this->script['rte_config'] = $field['config'];
		return $in;
		}

	public function input_number ($field){
		// type number makes nonsense !! crazy
		$in = "<input type=\"text\" class=\"text loose ".$field['css_class']."\" id=\"i".$field['me']."\" name=\"".$field['me']."\" value=\"".$field['value']."\" size=\"".$field['size']."\" />&nbsp;".$field['in_body'];
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_spin ($field){
		$pad = '';
		if (array_key_exists("pattern", $field)) {
			$pad = ' data-pad="'.sprintf($field['pattern'], 0).'"';
			$field['value'] = sprintf($field['pattern'], $field['value']);
			}
		if ($field['extra'] == 'range') {
			if (!$field['value']) {$field['value'] = $field['empty'];}
			$low = array_key_exists('low', $field) ? $field['low'].'&nbsp;' : '';
			$high = array_key_exists('high', $field) ? '&nbsp;'.$field['high'] : '';
			$in = "<span class=\"valigner\">$low<input type=\"range\" class=\"".$field['css_class']."\" id=\"i".$field['me']."\" name=\"".$field['me']."\" data-app=\"rangeOutput\" value=\"".$field['value']."\" max=\"{$field['max']}\" min=\"{$field['min']}\" step=\"{$field['interval']}\" />$high&nbsp;</span>".$field['in_body'];
			}
		else {
			$in = "<input type=\"text\" class=\"text loose ".$field['css_class']."\" id=\"i".$field['me']."\" name=\"".$field['me']."\" value=\"".$field['value']."\" size=\"".$field['size']."\" data-app=\"spin\" data-max=\"{$field['max']}\" data-min=\"{$field['min']}\" data-interval=\"{$field['interval']}\"$pad  />&nbsp;".$field['in_body'];
			$this->script['spin'] = 1;
			}
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_colorpicker ($field){
		if ($field['disable'] == true) {$in = "<input type=\"text\" class=\"text ".$field['css_class']."\" id=\"i".$field['me']."\" name=\"".$field['me']."\" style=\"background:".$field['value'].";color:".$field['value']."\" value=\"".$field['value']."\" size=\"10\" readonly=\"readonly\" />";}
		else {
			$colors = $field['extra'] ? $field['extra'] : ['Sienna', 'DarkGoldenRod', 'Gold', 'NavajoWhite', 'Orange', 'Tomato', 'Crimson', 'Fuchsia', 'Orchid', 'MediumPurple', 'DodgerBlue', 'CornFlowerBlue', 'Cyan', 'Turquoise', 'MediumSeaGreen', 'ForestGreen', 'LimeGreen', 'Lime', 'YellowGreen', 'DarkKhaki'];
			$in = "<span class='tiwrap'><input type=\"text\" class=\"text ".$field['css_class']."\" id=\"i".$field['me']."\" name=\"".$field['me']."\" style=\"background:".$field['value'].";color:".$field['value']."\" value=\"".$field['value']."\" size=\"10\" data-app=\"colorpicker\" /></span>&nbsp;".$field['in_body'];
			$table = '';
			foreach ($colors as $color) {
				$table .= "<div class='pal' style='background:$color' title='$color' data-val='$color'>&nbsp;</div>";
				}
			$in .= htmltag('div', 'id="col_i'.$field['me'].'" class="bubble"', $table);
			$this->script['colorpicker'] = 1;
			}
		$in = $this->make_row($field, $in);
		return $in;
		}


	public function input_custom ($field){
		$in;
		if (function_exists($field['extra'])){$in = $field['extra']($field['value'], $field['me'], $this->temp);}
		else {$in = preg_replace("/\+\+VALUE\+\+/", $field['value'], $field['extra']);}
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_readonly_lookup($field){
		global $db;
		$query = "SELECT `{$field['lid']}`, `{$field['lval']}` FROM `{$field['ltable']}` WHERE `{$field['lid']}` = ?";
		$arg = $db->prepare($query);
		$arg->execute(array($field['value']));
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		$v = is_array($data)? $data[$field['lval']] : '*';
		$in = "<p>$v <input type=\"hidden\" id=\"i".$field['me']."\" name=\"".$field['me']."\" value=\"".$field['value']."\"  /></p>".$field['in_body'];
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_lookup($field){
		global $db;
		$grouped = $field['lgroup'] ? "`{$field['lgroup']}`, " : "";

		if (is_array($field['lval'])) {
			$fields = ' CONCAT(';
			foreach ($field['lval'] as $v) {$fields .= "`$v`, ' ',";}
			$fields = preg_replace('/,$/', '', $fields);
			$fields .= ") AS `{$field['lval'][0]}`";
			$label = $field['lval'][0];
			}
		else {$fields = "`{$field['lval']}`"; $label = $field['lval'];}

		$limit = array_key_exists('absLimit', $field) ? ' LIMIT '.$field['absLimit'] : '';
		if ($field['lclause']) {
			if (!preg_match('/where/', $field['lclause'])) {$field['lclause'] = "where {$field['lclause']}";}
			}
		$query = "SELECT `{$field['lid']}`, $grouped$fields FROM `{$field['ltable']}` {$field['lclause']} ORDER BY $grouped`{$field['lord']}` {$field['lsort']}$limit";
		$arg = $db->prepare($query);
		$arg->execute();
		$err = $arg->errorInfo();
		$error = array_key_exists(2, $err) ? $err[2] : "";
		//$error .= $query;
		$rows = $arg->rowCount();
		if ($rows <= $field['limit']) {
			$opt = array();
			while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
				if ($grouped) {array_pop($opt, array($data[$field['lid']], $data[$label], $data[$field['lgroup']]));}
				else {array_push($opt, array($data[$field['lid']], $data[$label]));}
				}
			$field['extra'] = $opt;
			$in = $this->input_array($field);
			}
		else {$in = $this->input_biglookup($field);}
		$in .= $error;
		return $in;
		}

	public function input_biglookup($field) {
		$this->script['aco'] = 1;
		$field['size'] -= 2;
		$lookup_value = $this->get_lookup($field, $field['value']);
		$hidden = $field['me']."_hidden";
		$minions = ''; $mifi = '';
		if (array_key_exists('minions', $field)) {
			$i = 1;
			foreach ($field['minions'] as $k) {
				$mifi .= ", 'mifi$i': '$k'";
				$minions .= "\$(\"#i$k\").val(li.data[$i]);";
				$i++;
				}
			}

		if (is_array($field['lval'])) {
			$field['lval'] = implode('|', $field['lval']);
			}

		$in = get_icon('far-keyboard', i18n('type_ahead'))."&nbsp;<input type='hidden' id='$hidden' name='{$field['me']}' value='{$field['value']}' />
		<input type='text' id='i{$field['me']}' name='human{$field['me']}' value='$lookup_value' class='text{$field['css_class']}' size='{$field['size']}' />\n";
		$in .=<<<TNIRP
<script>
function fillID{$field['me']} (li){\$("#$hidden").val(li.data[0]);$minions}
\$(document).ready(function (){\$("#i{$field['me']}").autocomplete("{$this->html['myurl']}",{extraParams:{sid: '{$this->html['sid']}', '_id': 'ajax', todo: 'autofill', table:'{$field['ltable']}',field:'{$field['lval']}',id_field:'{$field['lid']}',clause:'{$field['lsendclause']}'$mifi},selectFirst:1,onItemSelect:fillID{$field['me']}})});
</script>
TNIRP;
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_array($field){
		$css = $field['css_class'] ? " class='{$field['css_class']}'" : "";
		$dis = $field['disable'] ? " disabled=disabled" : "";
		$icons = array_key_exists("icons", $field) ? 1 : 0;
		$fonts = array_key_exists("fontawesome", $field) ? 1 : 0;
		$filter = array_key_exists("filter", $field) ? $field['filter'] : 0;
		$enhanSel = $icons ? "  data-app=\"enhanSel\"" : "";
		$enhanSel = $fonts ? "  data-app=\"enhanSel\"" : $enhanSel;
		$in = "<select id='i{$field['me']}' name='{$field['me']}'$css{$field['data_attr']}$enhanSel>\n";
		$i = 1;
		$first = i18n('none');
		if ($field['duty']) {$first = i18n('no_selection');}
		if (array_key_exists("all", $field)) {$first = i18n('all');}
		$in .= "\t<option class='zero_opt' value=''>$first</option>\n";
		$readonly = [0, ''];
		foreach ($field['extra'] as $f) {
			if (is_array($f)) {
				$selected = $f[0] == $field['value'] ? " selected='selected'" : "";
				$dis = '';
				if (array_key_exists("enable", $field)) {
					if (!in_array($f[0], $field['enable'])) {$dis = ' disabled="disabled"';}
					}
				list($val, $title) = str_eclipse($f[1], $field['size']);
				$in .= "\t<option value='$f[0]'$title$selected$dis>$val</option>\n";
				if ($f[0] == $field['value']) {$readonly =  [$field['value'], $val];}
				}
			else {
				$true = array_key_exists("raw", $field) ? $f : $i;
				$icon = $icons ? " data-img='/co_icons/{$field['icons'][$i-1]}.png'" : "";
				$font = '';
				if ($fonts) {
					$fo = get_icon($field['fontawesome'][$i-1], '');
					preg_match( '/class="([^"]*)"/i', $fo, $m);
					$fo = $m[1];
					$font = " data-fa=\"$fo\"";
					}
				$selected = $true == $field['value'] ? " selected='selected'" : "";
				$dis = '';
				if (array_key_exists("enable", $field)) {
					if (!in_array($true, $field['enable'])) {$dis = ' disabled="disabled"';}
					}
				$f = array_key_exists("view", $field) ? $field['view'][$i-1] : $f;
				list($val, $title) = str_eclipse($f, 45);
				$in .= "\t<option$icon$font value='$true'$title$selected$dis>$val</option>\n";
				if ($true == $field['value']) {$readonly =  [$field['value'], $val];}
				$i++;
				}
			}
		$in .= "</select>";
		if (array_key_exists('readonly', $field)){$in =  "<p>$readonly[1] <input type=\"hidden\" id=\"i".$field['me']."\" name=\"".$field['me']."\" value=\"".$readonly[0]."\"  /></p>";}
		elseif ($icons || $fonts) {$this->script['enhanSel'] = 1;}
		else {$in = "<span class='selectwrap'>$in</span>";}
		if ($field['in_body']) {$in .= "&nbsp;".$field['in_body'];}
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_raw_select($field) {
		global $db;
 		$in = "<select id='i{$field['me']}' name='{$field['me']}'$css{$field['data_attr']}>\n";
		$i = 1;
		$first = i18n('none');
		if ($field['duty']) {$first = i18n('no_selection');}
		if (array_key_exists("all", $field)) {$first = i18n('all');}
		$in .= "\t<option class='zero_opt' value=''>$first</option>\n";

		$arg = $db->prepare("SELECT DISTINCT `{$field['me']}` FROM `$this->table` WHERE `{$field['me']}` <> '' ORDER BY `{$field['me']}`;");
		$arg->execute();
		while ($d = $arg->fetch(PDO::FETCH_ASSOC)) {
			$selected = $d[$field['me']] == $field['value'] ? " selected='selected'" : "";
			$in .= "\t<option class='zero_opt' value='{$d[$field['me']]}'$selected>{$d[$field['me']]}</option>\n";
			}

		$in .= "</select>";
		$in = "<span class='selectwrap'>$in</span>";
		if ($field['in_body']) {$in .= "&nbsp;".$field['in_body'];}
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_country($field) {
		global $html, $con, $db;
		$lang = $html['user']['language'] ? $html['user']['language'] : $con['ln'];
		$query = "SELECT `$lang`, `iso3166` FROM `countries`";
		if (array_key_exists("clause", $field)) {$query .= "WHERE ".$field['clause'];}
		$query .= " ORDER BY `iso3166`;";
		$css = $field['css_class'] ? " class='{$field['css_class']}'" : "";
		$dis = $field['disable'] ? " disabled=disabled" : "";
		$in = "<select id=\"i{$field['me']}\" name=\"{$field['me']}\"$css data-app=\"enhanSel\">\n";

		$flags = "";
		/*output to combine flags with image magick
		$flags = "montage -background '#ffffff' -tile 1x -geometry +0+2 ";
		*/
		$y = 0;
		$firstflag = "unknown";
		$first = i18n('none');
		if ($field['duty']) {$first = i18n('no_selection');}
		if (array_key_exists("all", $field)) {$first = i18n('all');}
		$in .= "\t<option value=''>$first</option>\n";
		$arg = $db->prepare($query);
		$arg->execute();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$data[$lang] = htmlentities($data[$lang]);
			$selected = $data['iso3166'] == $field['value'] ? " selected='selected'" : "";
			if ($selected) {$firstflag = $data['iso3166'];}
			#$flags .= "{$data['iso3166']}.png ";
			$iso = strtoupper($data['iso3166']);
			if (array_key_exists("clause", $field)) {$in .= "
				<option value='{$data['iso3166']}' data-img='/co_icons/flags/{$data['iso3166']}.png'$selected>$iso - $data[$lang]</option>";
				}
			else {
				$in .= "
				<option value='{$data['iso3166']}' data-img='/co_icons/flags/flags22.png' data-img-offset='-{$y}'$selected>$iso - $data[$lang]</option>";
				}
			$y += 15;
			}
		// $flags .= "flagsxx.png";
		$in .= "
		</select>&nbsp;".$field['in_body'].$flags;
		$in = $this->make_row($field, $in);
		$this->script['enhanSel'] = 1;
		return($in);
		}

	public function input_radio ($field){
		if (array_key_exists("cols", $field)) {
			switch ($field['cols']) {
				case 3:
					$col_class = 'col w4 l6'; break;
				case 2:
					$col_class = 'col w6'; break;
				case 1:
					$col_class = ''; break;
				default:
					$col_class = 'col w3 l4 m6'; break;
				}
			}
		else {$col_class = 'col w3 l4 m6';}
		$in = "<fieldset id='i{$field['me']}' class='inside {$field['css_class']}'><legend>{$field['caption']}</legend>\n".$field['in_body'];
		$i = 1;
		foreach ($field['extra'] as $f) {
			$true = array_key_exists("raw", $field) ? $f : $i;
			$key = array_key_exists("raw", $field) ? array_search($f, $field['extra']) : $i-1;
			$selected = $true == $field['value'] ? "  checked='checked'" : "";
			$v = array_key_exists("view", $field) ? $field['view'][$key] : $f;
			$icon = array_key_exists("icons", $field) ? get_icon($field['icons'][$key], '')."&nbsp;" : '';
			$in .= "<div class='$col_class'><input type='radio' id='i{$field['me']}$i' name='{$field['me']}' value='$true'$selected />&nbsp;<label for='i{$field['me']}$i'>$icon$v</label></div>";
			$i++;
			}
		$in .= "</fieldset>\n";
		return $in;
		}

	public function input_multicheck($field) {
		global $db;
		if (!array_key_exists("row_class", $field)) {$field['row_class'] = 'col w3 l4 m6';}
		if (!is_array($field['value'])) {$field['value'] = explode(',', $field['value']);}
		$in = "<fieldset id='i{$field['me']}' class='{$field['css_class']}'><legend>{$field['caption']}</legend>\n".$field['in_body'];

		if ($field['raw']) {
			$i = 1;
			foreach ($field['extra'] as $k => $v) {
				$selected = ""; $sel_class = "";
				foreach ($field['value'] as $k1) {
					if ($v == $k1) {$selected = " checked='checked'"; $sel_class = 'class="green"';}
					}
				$disable = $field['disable'] == true ? 'readonly="readonly"' : '';
				$vv = array_key_exists("view", $field) ? $field['view'][$k] : $v;
				$in .= "<div class='{$field['row_class']}'><input id='i{$field['me']}$i' name='{$field['me']}[$i]' type='checkbox' value='$v'{$field['data_attr']}$selected $disable />&nbsp;<label for='i{$field['me']}$i'$sel_class>$vv</label></div>";
				$i++;
				}
			}
		else {
			if ($field['lclause']) {
				if (!preg_match('/where/', $field['lclause'])) {$field['lclause'] = "where {$field['lclause']}";}
				}
			$arg = $db->prepare("SELECT DISTINCT `{$field['lid']}`, `{$field['lval']}` FROM `{$field['ltable']}` {$field['lclause']} ORDER BY `{$field['lord']}`");
			$arg->execute();
			$i = 1;
			while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
				$selected = ""; $sel_class = "";
				foreach ($field['value'] as $k) {
					if ($data[$field['lid']] == $k) {$selected = " checked='checked'"; $sel_class = 'class="green"';}
					}
				$in_field_by_array = array_key_exists("in_field_by_array", $field) ? $field['in_field_by_array'][$data[$field['lid']]] : '';
				$disable = $field['disable'] == true ? 'readonly="readonly"' : '';
				$in .= "<div class='{$field['row_class']}'><input id='i{$field['me']}$i' name='{$field['me']}[$i]' type='checkbox' value='{$data[$field['lid']]}'{$field['data_attr']}$selected $disable />&nbsp;<label for='i{$field['me']}$i'$sel_class>{$data[$field['lval']]} $in_field_by_array</label></div>";
				$i++;
				}
			}
		$in .= "\n</fieldset>";
		return($in);
		}

	public function input_multilookup($field) {
		global $db;
		if (!is_array($field['value'])) {$field['value'] = explode(',', $field['value']);}
		if ($field['lclause']) {
			if (!preg_match('/where/', $field['lclause'])) {$field['lclause'] = "where {$field['lclause']}";}
			}
		$arg = $db->prepare("SELECT DISTINCT `{$field['lid']}`, `{$field['lval']}` FROM `{$field['ltable']}` {$field['lclause']} ORDER BY `{$field['lord']}`");
		$arg->execute();
		$i = 1;
		$in = "<select id='i{$field['me']}' name='{$field['me']}[]'$css{$field['data_attr']} size='5' multiple='multiple'>\n";
		$first = i18n('none');
		if ($field['duty']) {$first = i18n('no_selection');}
		if (array_key_exists("all", $field)) {$first = i18n('all');}
		$in .= "\t<option class='zero_opt' value=''>$first</option>\n";
		$collect = [];
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$selected = ""; $sel_class = "";
			foreach ($field['value'] as $k) {
				if ($data[$field['lid']] == $k) {
					$selected = " selected='selected'";
					array_push($collect, $data[$field['lval']]);
					}
				}
			list($val, $title) = str_eclipse($data[$field['lval']], $field['size']);
			$in .= "\t<option value='{$data[$field['lid']]}'$title$selected>$val</option>\n";
			$i++;
			}
		$in .= "</select>\n";
		if (count($collect)) {$in .= htmltag('p', '', implode(', ', $collect));}
		$in = $this->make_row($field, $in);
		return($in);
		}

	public function input_hidden ($field){
		$in = "<input type=\"hidden\" id=\"i".$field['me']."\" name=\"".$field['me']."\" value=\"".$field['value']."\"  />\n";
		return $in;
		}

	public function input_readonly ($field){
		$val = $field['css_class'] ? "<span class='{$field['css_class']}'>{$field['value']}</span>" : $field['value'];
		if (array_key_exists("pattern", $field)) {$val = sprintf($field['pattern'], $field['value']);}
		$in = "<p>$val <input type=\"hidden\" id=\"i".$field['me']."\" name=\"".$field['me']."\" value=\"".$field['value']."\"  /> {$field['in_body']}</p>";
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_date($field){
		//if (!$field['default']) {$field['default'] = "1970-01-01";}
		if (!$field['value']){$field['value'] = $field['default'];}
		# default can overwrite a given value
		if ($field['extra'] == "overwrite") {$field['value'] = $field['default'];}
		$size = 12;
		if ($field['type'] == "timestamp") {$size = 23;}
		$this->script['date'] = 1;
		$in = "<span class='tiwrap'><input type=\"text\" class=\"text loose ".$field['css_class']."\" id=\"i".$field['me']."\" name=\"".$field['me']."\" value=\"".$field['value']."\" size=\"$size\"  data-app=\"JQdate\" /></span>&nbsp;".$field['in_body'];
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_suggest($field) {
		$this->script['aco'] = 1;
		$field['size'] -= 3;
		$minions = ''; $mifi = ''; $mifill = ''; $miscript = '';
		if (array_key_exists('minions', $field)) {
			$i = 1;
			foreach ($field['minions'] as $k) {
				$mifi .= ", 'mifi$i': '$k'";
				$minions .= "\$(\"#i$k\").val(li.data[$i-1]);";
				$i++;
				}
			$miscript = "function fillIn{$field['me']} (li){{$minions}}";
			$mifill = ", onItemSelect:fillIn{$field['me']}";
			}
		$in = get_icon('far-keyboard', i18n('type_ahead'))."&nbsp;<input type='text' id='i{$field['me']}' name='{$field['me']}' value='{$field['value']}' class='text {$field['css_class']}' size='{$field['size']}' />&nbsp;".$field['in_body'];
		$in .=<<<EOL
		<script>
		$miscript
		\$(document).ready(function (){\$("#i{$field['me']}").autocomplete("{$this->html['myurl']}",{extraParams:{sid: '{$this->html['sid']}', '_id': 'ajax', todo: 'suggest', table:'{$field['ltable']}',field:'{$field['lval']}'$mifi,clause:"{$field['lsendclause']}"},selectFirst:1$mifill})});
		</script>
EOL;
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_add_tags($field) {
		$this->script['aco'] = 1;
		$field['size'] -= 3;
		$in = "<fieldset id='fi_{$field['me']}' class='{$field['css_class']}'><legend>{$field['caption']}</legend>\n".$field['in_body'];
		$in .= get_icon('far-keyboard', i18n('type_ahead'))."&nbsp;<input type='text' id='i{$field['me']}' name='{$field['me']}' value='' class='text {$field['css_class']}' size='{$field['size']}' />&nbsp;".$field['in_body'];
		$tags = '&nbsp;';
		if ($field['value']) {
			$vals = $this->get_multi_lookup($field);
			foreach ($vals as $k=>$v) {
				$tags .= htmltag('span', 'class="tag" data-id="'.$k.'"', $v);
				}
			}
		// script is in database as html-snippet
		$noMatch = array_key_exists('match', $field) ? '' : "onNoMatch: newTag_{$field['me']}";
		$pd = [
			   'me' => $field['me'],
			   'params' => "\"{$this->html['myurl']}\",{extraParams:{sid: '{$this->html['sid']}', '_id': 'ajax', todo: 'autofill', table:'{$field['ltable']}',field:'{$field['lval']}',id_field:'{$field['lid']}',clause:'{$field['lsendclause']}'},selectFirst:1,onItemSelect: collectTags_{$field['me']}, $noMatch}"
			   ];
		$this->scripts .= parse_in('gui_add_tags', $pd);
		$in .=<<<EOL
		<div id="collector_{$field['me']}" class="stat_text">$tags</div>
		</fieldset>
EOL;
		return $in;
		}

	public function input_pwd($field){
		$placeholder = substr($field['value'], 0, 12);
		$in = "<input type=\"password\" class=\"text ".$field['css_class']."\" id=\"i".$field['me']."\" name=\"".$field['me']."\" value=\"".$placeholder."\" size=\"".$field['size']."\" />&nbsp;";
		if (array_key_exists('repeat', $field)) {
			$in .= "<br /><input type=\"password\" class=\"text ".$field['css_class']."\" id=\"icc".$field['me']."\" name=\"cc".$field['me']."\" value=\"".$placeholder."\" size=\"".$field['size']."\" />";
			$field['caption'] .= "<br />".i18n('pwd_twice');
			}
		if (array_key_exists('pwdCheck', $field)) {
			$pd = [
			   'me' => "i".$field['me'],
			   'cmp' => "icc".$field['me']
			   ];
			$in .= parse_in('gui_pwd_check', $pd);
			}
		$in .= $field['in_body'];
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_flag($field){
		$checked = $field['value'] ? " checked=\"checked\"" : "";
		$in = "<input type=\"checkbox\" id=\"i{$field['me']}\" name=\"{$field['me']}\" $checked class=\"text {$field['css_class']}\"{$field['data_attr']} />&nbsp;".$field['in_body'];
		$in = $this->make_row3($field, $in);
		return $in;
		}

	public function input_icons($field) {
		$css = $field['css_class'] ? " class='{$field['css_class']}'" : "";
		$ext = array_key_exists('img_ext', $field) ? $field['img_ext'] : 'png';
		$x = 0; $y = 0; $opt = '';
		foreach(glob("{$this->html['dir']}/{$field['icon_dir']}/*$ext") as $file) {
			if (!$x) {$x=48; $y=48;}
			$icon = basename($file);
			$micon = preg_replace("/\.$ext$/", "", $icon);
			$selected = "";
			if ($micon == $field['value']) {$selected = " selected='selected'";}
			$opt .= "<option data-img='{$field['icon_dir']}/$icon' value='$micon'$selected>$micon</option>\n";
			}
		$in = "<select name='{$field['me']}' id='i{$field['me']}' data-app=\"enhanSel\"$css>
		$opt
		</select>&nbsp;".$field['in_body'];
		$this->script['enhanSel'] = ['img_w' => $x, 'img_h' => $y, 'width' => $field['size'].'em'];
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_link($field) {
		$in = "<span class='tiwrap'><input type='text' class='text {$field['css_class']}' id='i{$field['me']}' name='{$field['me']}' value='{$field['value']}' size='30' maxlength='80' data-app='load_link' /></span>";
		$this->script['file'] = 1;
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_image($field) {
		$in = "<input type='hidden' id='i{$field['me']}' name='{$field['me']}' value='{$field['value']}' />";
		if ($field['extra'] == "display") {
			$in .= get_thumb($field['value'], "ti{$field['me']}", "thumbs");
			}
		else {
			$field['caption'] .= "<p class='center'>".get_thumb($field['value'], "ti{$field['me']}", "thumbs")."</p>";
			$accept = $field['accept'] ? " accept='{$field['accept']}'" : 'accept=".png, .jpg, .jpeg, .gif, .svg"';
			$in = "\n\t<p>".i18n('upload_img')."<br /><label class='btn_upload' for='ifile{$field['me']}'><span>".i18n('search')."...</span><i class='fas fa-upload fa-lg white'></i></label><input id='ifile{$field['me']}' type='file' name='file{$field['me']}'  $accept data-app='fupload' class='hidden' /></p>";
			$this->script['fupload'] = 1;
			if ($field['extra'] != "upload") {
				$in .= "\n\t<p>".i18n('img_exists')."<br /><span class='tiwrap'><input type='text' class='text {$field['css_class']}' id='i{$field['me']}' name='{$field['me']}' value='{$field['value']}' size='30' maxlength='80' data-app='load_img' /></span></p>";
				$this->script['img'] = 1;
				}
			else {$in .= "<input type='hidden' id='i{$field['me']}' name='{$field['me']}' value='{$field['value']}' />";}
			}
		$in .= $field['in_body'];
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function input_file($field) {
		$accept = $field['accept'] ? " accept='{$field['accept']}'" : "";
		$in = "<label class='btn_upload' for='ifile{$field['me']}'><span>".i18n('search')."...</span><i class='fas fa-upload fa-lg white'></i></label><input type='file' id='ifile{$field['me']}' name='file{$field['me']}' $accept data-app='fupload' class='hidden'  /><br />";
		$this->script['fupload'] = 1;
		if ($field['extra'] == "browser") {
			$in .= "<span class='tiwrap'><input type='text' class='text {$field['css_class']}' id='i{$field['me']}' name='{$field['me']}' value='{$field['value']}' size='30' maxlength='50' data-app='load_link' /></span>";
			$this->script['file'] = 1;
			}
		elseif ($field['extra'] == "upload") {}
		else {$in .= "<input type='hidden' id='i{$field['me']}' name='{$field['me']}' value='{$field['value']}' />{$field['value']}";}
		$in = $this->make_row($field, $in);
		return $in;
		}

	public function subform($field) {
		if (!array_key_exists("height", $field)) {$field['height'] = 350;}
		$p = array_key_exists("params", $field) ? $field['params'] : '';
		$popup = array_key_exists("popup", $field) ? true : false;
		if ($popup) {
			$a = "<a href='{$this->action}?_id={$field['conf']}&amp;sid={$this->html['sid']}&amp;{$field['foreign']}={$this->rid}$p' target='_blank' class='popupform'>".i18n('more')."...</a>";
			$in = $in = $this->make_row($field, $a);
			$this->script['popup'] = ['t' => $field['caption'], 'h' => $field['height'], 'w' => 1024];
			}
		else {
			$in = "
			<div class='row clrfx' id='row{$field['me']}'>
			<iframe id='subform' src='{$this->action}?_id={$field['conf']}&amp;sid={$this->html['sid']}&amp;{$field['foreign']}={$this->rid}$p' height='{$field['height']}' width='98%' name='subform' class='{$field['css_class']}'>
				<p>".i18n('no_frame')."</p>
			</iframe>
			</div>";
			}
		return $in;
		}

	public function make_row($field, $in){
		$a = $this->label_size;
		$b = 12 - $a;
		if (array_key_exists('row2', $field)) {
			if ($field['row2'] === 'alt') {$row = $this->make_row4($field, $in);}
			else {$row = $this->make_row2($field, $in);}
			}
		elseif (array_key_exists('norow', $field)) {$row = $in;}
		else {
			$row = "
			<div class='row clrfx {$field['css_row']}' id='row{$field['me']}'>
			<div class='col w$a first label variant {$field['css_label']}'>
			<label for='i{$field['me']}'>{$field['caption']}</label>&nbsp;{$field['in_label']}
			</div>
			<div class='col w$b last'>$in</div>
			</div>";
			}
		return $row;
		}

	public function make_row2($field, $in){
		$row = "
		<div class='row clrfx' id='row{$field['me']}'>
		<p class='{$field['css_label']}'>	<label for='i{$field['me']}'>{$field['caption']}</label>&nbsp;{$field['in_label']}</p>
		$in
		</div>";
		return $row;
		}

	public function make_row3($field, $in){
		if ($field['extra'] == 'outset') {
			$row = "
			<div class='row clrfx {$field['css_label']}' id='row{$field['me']}'>
			$in <label for='i{$field['me']}'>{$field['caption']}</label>&nbsp;{$field['in_label']}
			</div>";
			}
		else {
			$row = "
			<div class='row clrfx' id='row{$field['me']}'>
			<div class='col w2 first'>&nbsp;</div>
			<div class='col w10 last'>$in <label for='i{$field['me']}'>{$field['caption']}</label>&nbsp;{$field['in_label']}</div>
			</div>";
			}
		return $row;
		}

	public function make_row4($field, $in){
		$row = "
		<div class='row clrfx slideLab' id='row{$field['me']}'>
		$in	<label for='i{$field['me']}'><span>{$field['orig_caption']}</span></label>
		</div>";
		return $row;
		}

	public function start_fieldset($field) {
		$c = "";
		if ($this->fieldset_end) {$c = "\n</fieldset>\n";}
		$col = "";
		if ($field['collapsed']) {
			$this->script['collapse'] = 1;
			$col = " data-app='collapse'";
			}
		$icon = array_key_exists("icon", $field) ? get_icon($field['icon'], " ")."&nbsp;" : "";
		$c .= "\n<fieldset$col class='{$field['css_class']}'><legend>$icon{$field['caption']}</legend>\n{$field['in_body']}\n";
		$this->fieldset_end = array_key_exists("end", $field) ? $field['end'] : "last";
		return $c;
		}

	public function inputs_from_table() {
		global $db;
		$arg = $db->prepare("SHOW FULL COLUMNS FROM `{$this->table}`");
		$arg->execute();
		$inputs = array();
		while ($table_ref = $arg->fetch(PDO::FETCH_ASSOC)) {
			$empty = 0;
			$type = "text";
			$tt = preg_replace('/\(\d+\)/', '', $table_ref['Type']);
			switch ($tt) {
				case "char":
				case "varchar":
					array_push($this->search, $table_ref['Field']);
					$empty = '';
					break;
				case "tinytext":
				case "text":
				case "mediumtext":
				case "longtext":
					$type = "bigtext";
					array_push($this->search, $table_ref['Field']);
					$empty = '';
					break;
				case "date": $type = "date"; break;
				}

			$inputs[$table_ref['Field']]['db_Type'] = $table_ref['Type'];
			$inputs[$table_ref['Field']]['db_Null'] = $table_ref['Null'];
			$inputs[$table_ref['Field']]['db_Extra'] = $table_ref['Extra'];
			$inputs[$table_ref['Field']]['empty'] = $empty;

			if ($table_ref['Key'] == "PRI") {
				$this->primary = $table_ref['Field'];
				$inputs[$table_ref['Field']]['type'] = $type;
				array_push($this->table_fields, $table_ref['Field']);
				}
			else {
				$inputs[$table_ref['Field']]['type'] = $type;
				if ($table_ref['Null'] == "NO") {$inputs[$table_ref['Field']]['duty'] = 1;}
				if ($table_ref['Default']) {$inputs[$table_ref['Field']]['default'] = $table_ref['Default'];}
				array_push($this->table_fields, $table_ref['Field']);
				}
			}
		if (!in_array($this->orderby, $this->table_fields)) {$this->orderby = $this->primary;}
		return $inputs;
		}

	/**
	 * update $html
	 */
	public function html_in($html) {
		$this->html = $html;
		}

	private function html_out($content) {
		$html = $this->html;
		$html['content'] = $content;
		$html['scripts'] .= "\n".$this->scripts;
		$html['formtitle'] = $this->title;
		$html['title_suffix'] = $this->title;
		$bubble = bubble($this->myconf);
		if ($bubble) {$html['formtitle'] .= $bubble;}
		//else {$html['formtitle'] .= " <!-- $this->myconf --> ";}
		return $html;
		}

	private function input_defs() {
		global $db;
		$arg = $db->prepare("SHOW FIELDS FROM `{$this->table}`;");
		$arg->execute();
		while ($info = $arg->fetch(PDO::FETCH_ASSOC)) {
			preg_match('/^(\w+)\((.+)\)\s?(\w*)/', $info['Type'], $m);
			$type = isset($m[1]) ? strtoupper($m[1]) : strtoupper($info['Type']);
			$this->table_defs[$info['Field']]['length'] = isset($m[2]) ? $m[2] : '';
			if ($info['Null'] == 'YES') {$this->table_defs[$info['Field']]['empty'] = NULL;}
			else {
				if (! $info['Default'] && in_array($type, ['CHAR', 'VARCHAR', 'TEXT'])) {$info['Default'] = '';} // accurate type
				$this->table_defs[$info['Field']]['empty'] = $info['Default'];
				}
			}
		}

	public function expand_input($v) {
		if (array_key_exists($v['me'], $this->table_defs)) {
			if (array_key_exists('length', $this->table_defs[$v['me']])) {if (!array_key_exists("max_size", $v)) {$v['max_size'] = $this->table_defs[$v['me']]['length'];}}
			if (array_key_exists('empty', $this->table_defs[$v['me']])) {$v['empty'] = $this->table_defs[$v['me']]['empty'];}
			}
		if (!array_key_exists("type", $v)) {$v['type'] = "text";}

		switch ($v['type']) {
			case "number":
				if (!array_key_exists("size", $v)) { $v['size'] = 9;}
				$v['empty'] = 0; break;
			case "suggest":
			case "readonly_lookup":
			case "multicheck":
			case "multilookup":
			case "lookup":
			case "add_tags":
				if (!array_key_exists("lid", $v)) {$v['lid'] = "id";}
				if (!array_key_exists("lord", $v)) {$v['lord'] = "id";}
				if (!array_key_exists("lclause", $v)) {$v['lclause'] = ""; $v['lsendclause'] = "";}
				else {$v['lsendclause'] = base64_encode($v['lclause']);}
				if (!array_key_exists("lgroup", $v)) {$v['lgroup'] = "";}
				if (!array_key_exists("lsort", $v)) {$v['lsort'] = "ASC";}
				if (!array_key_exists("limit", $v)) {$v['limit'] = 200;}
				if (!array_key_exists("raw", $v)) {$v['raw'] = false;}
				break;
			case "wysiwyg":
				if (!array_key_exists("config", $v)) {$v['config'] = "normal";}
				break;
			case "icons":
				if (!array_key_exists("icon_dir", $v)) {$v['icon_dir'] = "/co_icons";}
				if (!$v['css_class']) {$v['css_class'] = "icons";}
				break;
			case "image":
				if (!array_key_exists("prev_dir", $v)) {$v['prev_dir'] = "square";}
				if (!array_key_exists("nocache", $v)) {$v['nocache'] = false;}
				if (!array_key_exists("css_label", $v)) {$v['css_label'] = "h1";}
				if (!array_key_exists("accept", $v)) {$v['accept'] = false;}
				break;
			case "sort":
				if (!array_key_exists("do", $v)) {$v['do'] = false;}
				$v['size'] = 9;
				break;
			case "spin":
				if (!array_key_exists("max", $v)) {$v['max'] = 100;}
				if (!array_key_exists("min", $v)) {$v['min'] = 1;}
				if (!array_key_exists("interval", $v)) {$v['interval'] = 1;}
				if (!array_key_exists("size", $v)) { $v['size'] = 9;}
				if (!array_key_exists('css_class', $v)) { $v['css_class'] = 'loose';}
				$v['empty'] = 0;
				break;
			case "file":
				if (!array_key_exists("accept", $v)) {$v['accept'] = false;}
				break;
			case "flag":
				$v['empty'] = '';
				break;
			case "custom":
				if (!array_key_exists("view", $v)) {$v['view'] = false;}
				break;
			case "fieldset":
				if (!array_key_exists("collapsed", $v)) {$v['collapsed'] = 0;}
				break;
			}

		if (!array_key_exists("type", $v)) {$v['type'] = "text";}
		if (!array_key_exists("caption", $v)) {$v['caption'] = i18n($v['me']);}
		if (!array_key_exists("size", $v)) {$v['size'] = $this->defsize;}
		if (!array_key_exists("max_size", $v)) {$v['max_size'] = false;}
		if (!array_key_exists("duty", $v)) {$v['duty'] = 0;}
		if (!array_key_exists("table", $v)) {$v['table'] = 0;}
		if (!array_key_exists("css_td", $v)) {$v['css_td'] = '-';}
		if (!array_key_exists("empty", $v)) {$v['empty'] = NULL;}
		$v['orig_caption'] = $v['caption'];
		$nodefs = array("abbr", "default", "extra",	"css_label", "css_class", "css_row", "in_label", "in_body", "data_attr", "placeholder", "disable", "skip");
		foreach($nodefs as $name) {if (!array_key_exists($name, $v)) {$v[$name] = "";}}
		$this->captions[$v['me']] = $v['caption']; // collect caption array
		return ($v);
		}

	private function getTH($th) {
		$url = "{$this->action}?sid={$this->html['sid']}&amp;_id={$this->myconf}";
		$th_str = "<tr class='nodrop nodrag'>\n";
		$no_sort = ["lookup", "biglookup", "array", "radio", "multiselect", "flag", "n", "custom", "function"];
		foreach($th as $tha) {
			$arr = $this->q_arr;
			$sign = $this->order_sign[0];
			$thd = $tha[0];
			if (!in_array($tha[2], $no_sort)) {
				$arr["_ob"] = $tha[1];
				$arr["_o"] = 0;
				if ($arr["_ob"] == $this->q_arr["_ob"]) {
					$arr["_sb"] = $this->q_arr["_sb"] == 1 ? 2 : 1;
					$sign = $this->order_sign[$arr["_sb"]];
					}
				$href = $url."&amp;".http_build_query($arr, '', '&amp;');
				$thd = "<a href='$href'>$tha[0]</a>";
				if ($tha[2] == "sort" && $this->q_arr["_ob"] != $this->orderby) {
					$sign = get_icon("sortnew", i18n('sort_new'));
					$sign = preg_replace("/\<i/", "<i id='sortnew'", $sign);
					}
				}
			else {$sign = '';}
			if ($tha[2] == "n") {
				$alt = i18n('toggle_selection');
				if ($this->allow_box or $this->custom_box) {
					$sign = "<i class='far fa-check-square red fa-lg' title=\"$alt\" data-app=\"checkBoxControll\" /></i>&nbsp;";
					}
				}
			$th_str .= "<th>$sign&nbsp;$thd</th>\n";
			}
		$th_str .= "</tr>\n";
		return $th_str;
		}

	private function getTD($td, $id, $css) {
		$td_str = "<tr class='{$this->tr_class}' id='ROW$id'>\n";
		$this->tr_class = $this->tr_class == "shade" ? "cool" : "shade";
		foreach($td as $a=>$tdd) {
			$cl = $css[$a] != '-' ? " class=\"{$css[$a]}\"" : '';
			$td_str .= "\t<td$cl>$tdd</td>\n";
			}
		$td_str .= "</tr>\n";
		return $td_str;
		}

	private function getTile($td,$th) {
		//$ii = $this->tile_counter % 4;
		$td_str = "";
		//if ($ii == 0 && $this->tile_counter != 0){$td_str .= "</div><div class='row clrfx'>\n";}
		$this->tile_counter++;
		$td_str .= "<li class='t4 box'>\n";
		$action = "";
		$i = 0;
		foreach($td as $tdd) {
			if ($th[$i][2] == "n") {$action .= "\t<p class='flex-bottom'>$tdd</p>\n";}
			else {$td_str .= "\t<span title='{$th[$i][0]}'>$tdd</span><br />\n";}
			$i++;
			}
		$td_str .= "$action</li>\n";
		return $td_str;
		}

	private function get_image_load($val) {
		$target = clean_var(param('target'), "w");
		$img = $val;
		if (preg_match('/_prm_src/', $target)) {$val = "/pictures/normal/".$val;}
		$val = "<a data-app='set_link' data-value='$val' data-target='$target'>".get_thumb($img, "", "square")."</a>";
		$this->script['set_link'] = 1;
		return $val;
		}

	private function get_sort($field, $val, $id_val) {
		if ($field['do'] == true) {
			$this->sortable = true;
			$val = "<input type='text' name='sort$id_val' value='$val' size='3' maxlength='8' class='text sort' />";
			}
		return $val;
		}

	private function get_search_params($clean = 'w', $forget = false){
		$params = array("_id", "sid", "_w", "_ob", "_sb", "_s", "_l", "_o", "_hl", "_table"); # to be continued
		if ($forget) {$params = ["_id", "sid"];}
		if (!$this->html['sid']) {$params = ["_id"];}
		$hidden = "";
		$params = array_merge($params, $this->filters);
		foreach($params as $v) {
			if (is_array(param($v))) {} //TODO?
			else {$var = clean_var(param($v), $clean);}
			if ($v == "_id") {
				if (!$var) {$var = $this->myconf;}
				if ($this->force_myconf) {$var = $this->myconf;}
				}
			if (!$var && $v == "_id") {$var = $this->myconf;}
			//if (!$var && in_array($v, $this->filters)) {$var = $this->inputs[$v]['value'];}
			if ($var) {$hidden .= "\n\t\t<input type='hidden' name='$v' value='$var' />\n";}
			}
		return $hidden;
		}

	private function searching($input){
		$words = $this->words;
		$arr = preg_split("/\s/", $words, -1, PREG_SPLIT_NO_EMPTY);
		$offset = $this->offset;
		if (is_array($this->orderby)) {$this->orderby = implode('`, `', $this->orderby);}
		$orderby = param('_ob') ? clean_var(param('_ob'), "w") : $this->orderby;
		// precaution
		if (!in_array($orderby, $this->table_fields)) {$orderby = $this->orderby;}
		$my_orderby = "`$orderby`";
		switch ($this->defsort) {
			case "ASC": $sort = 1; break;
			case "DESC": $sort = 2; break;
			}
		$sortby = param('_sb') ? clean_var(param('_sb'), "n") : $sort;
		$sfield = param('_s') ? clean_var(param('_s'), "w") : "";
		$logical = param('_l') ? clean_var(param('_l'), "n") : 1;
		$lc = array('','','');
		$filters = array();
		$lc[$logical] = " checked='checked'";
		$log = $logical == 1 ? "AND" : "OR";
		switch ($sortby) {
			case 1: $sort = "ASC"; break;
			case 2: $sort = "DESC"; break;
			}

		# query #
		$clause = "";
		$this->export_q = "SELECT";
		if (isset($this->xml_fields)) {
			foreach($this->xml_fields as $a){$this->export_q .= " `$a`,";}
			$this->export_q = preg_replace("/,$/", "", $this->export_q);
			}
		else {$this->export_q .= " *";}

		# fulltext
		$fulltext_clause = "";
		$fulltext = $this->get_fulltext();
		if ($words and $sfield == 'fulltext') {
			$fulltext = $this->get_fulltext();
			$fields = ''; $keywords = '';
			foreach ($fulltext as $field) {
				$fields .= "`$field`, ";
				}
			foreach ($arr as $w) {$keywords .= "+$w* ";}
			$fields = preg_replace("/\,\s$/", "", $fields);
			$keywords = preg_replace("/\s$/", "", $keywords);
			$this->query .= ", match ($fields) against ('$keywords') as `score`";
			$this->export_q .= ", match ($fields) against ('$keywords') as `score`";
			$fulltext_clause = "match ($fields) against ('$keywords' IN BOOLEAN MODE)";
			if (!param('_ob')) {
				$my_orderby = "`score`";
				$sort = 'DESC';
			 	}
			}

		if ($this->clause) {$clause .= " WHERE $this->clause";}
		foreach ($this->filters as $f) {
			if (is_array(param($f))) {
				$in = '';
				$i = 0;
				foreach (param($f) as $va) {
					$filters[$f][$i] = $va; $i++;
					$in .= clean_var($va, "l").',';
					}
				$in = preg_replace("/\,$/", '', $in);
				if (preg_match("/WHERE/", $clause)) {$clause .= " AND ";}
				else { $clause .= " WHERE ";}
				$junction = $this->table."_junction_{$input[$f]['ltable']}";
				$clause .= "`id` IN(SELECT `id_$this->table` FROM `$junction` WHERE `id_{$input[$f]['ltable']}` IN($in))";
				}
			else {
				$val = clean_var(param($f), "l");
				if ($val) {
					if (preg_match("/WHERE/", $clause)) {$clause .= " AND ";}
					else { $clause .= " WHERE ";}
					if ($val == 'ISNULL') {
						$clause .= "ISNULL(NULLIF(`$f`, '')) ";
						}
					elseif ($val == 'NOTISNULL') {
						$clause .= "NOT ISNULL(NULLIF(`$f`, '')) ";
						}
					else {
						$clause .= "`$f` like ? ";
						array_push($this->taint, $val);
						}
					$filters[$f] = $val;
					}
				}
			}
		if ($words) {
			if (preg_match("/WHERE/", $clause)) {$clause .= " AND ";}
			else { $clause .= " WHERE ";}
			foreach ($arr as $word) {
				if ($sfield != "fulltext") {
					$clause .= "(`$sfield` like ?) $log ";
					array_push($this->taint,"%$word%");
					}
				}
			if ($sfield == "fulltext") {$clause .= $fulltext_clause;}
			#delete the last "or" or "and"
			$clause = preg_replace("/OR\s$/", "", $clause);
			$clause = preg_replace("/AND\s$/", "", $clause);
			}

		if ($my_orderby) {$clause .= " order by $my_orderby $sort";}
		$this->query .= " FROM `$this->table`";
		$this->export_q .= " FROM `$this->table`";
		$this->query .= $clause;
		$this->export_q.= $clause;

		# free param
		foreach($input as $k=>$v){if($v['type'] == "free"){$this->freebies[$k] = clean_var(param($k), "w");}}

		# array for URL query
		$this->q_arr = ["_l" => $logical, "_sb" => $sortby, "_ob" => $orderby, "_o" => $offset, "_hl" => $this->q_limit];
		if ($words) {$this->q_arr["_w"] = $words;}
		if ($sfield) {$this->q_arr["_s"] = $sfield;}
		foreach ($filters as $f => $v) {$this->q_arr[$f] = $v;}
		foreach ($this->freebies as $f => $v) {$this->q_arr[$f] = $v;}

		# searchfrom #
		$select = ["me" => "_hl", "caption" => i18n('hits_page'), "type" => "array", "raw" => 1, "extra" => [10,20,50,100,200,500], "value" => $this->q_limit, 'row2' => true, 'css_class' => 'loose'];
		$select = $this->expand_input($select);
        $limitbox = $this->input_array($select);
		$search_input = "";
		if ($this->search) {
			$search_input = "<p><input type='text' class='text loose' name='_w' id='i_w' size='30' value='{$this->words}' placeholder='".i18n('search')."' />";
			$logic_box = '';
			if (!$this->no_logical) {
				$logic_box = "<br />
				<input type='radio' name='_l' value='1' id='logon'$lc[1] />&nbsp;<label for='logon'>".i18n('and')."</label>&nbsp;
				<input type='radio' name='_l' value='2' id='logoff'$lc[2] />&nbsp;<label for='logoff'>".i18n('or')."</label>";
				}
			if (count($this->search) > 1) {
				$options = ''; $radio = '';
				foreach ($this->search as $a) {
					$capt = $a == 'fulltext' ? i18n($a) : $input[$a]['caption'];
					$selected = $a == $sfield ? " selected" : "";
					$checked = $a == $sfield ? " checked" : "";
					if ($a == 'fulltext' and !$sfield) {$checked = " checked";}
					$options .= "<option value='$a'$selected>$capt</option>";
					$radio .= "<div class=\"col w3 l4 m6\"><input name=\"_s\" id=\"isa_$a\" type=\"radio\" value=\"$a\"$checked>&nbsp;<label for=\"isa_$a\">$capt</label></div>";
					}
				if ($this->radio_search_select){
					$search_input .= $logic_box.htmltag("div", 'class="row clrfx"',  $radio)."<hr />";
					}
				else {
					$sel = htmltag('select', 'name="_s"', $options);
					$sel = chop($sel); // after all that years still amazing...
					$search_input .= " in:&nbsp;<span class='selectwrap'>$sel</span>\n$logic_box</p>";
					}
				}
			else {$search_input .= "<input type='hidden' name='_s' value='{$this->search[0]}'></p>";}
			}

		foreach ($this->filters as $f) {
			$input[$f]['all'] = true;
			if (is_array(param($f))) {$input[$f]['value'] = implode(',', param($f));}
			else {$input[$f]['value'] = clean_var(param($f), "w");}
			if ($input[$f]['value']) {$input[$f]['css_label'] = "filtered";}
			switch ($input[$f]['type']) {
				case "hidden": $search_input .= $this->input_hidden($input[$f]); break;
				case "readonly_lookup": $search_input .= $this->input_readonly_lookup($input[$f]); break;
				case "suggest": $search_input .= $this->input_suggest($input[$f]); break;
				case "lookup": $search_input .= $this->input_lookup($input[$f]); break;
				case "array":
				case "radio": $search_input .= $this->input_array($input[$f]); break;
				case "flag":
					$input[$f]['extra'] = ['on', 'ISNULL'];
					$input[$f]['view'] = [i18n('yes'), i18n('no')];
					$input[$f]['raw'] = true;
					$search_input .= $this->input_array($input[$f]); break;
				case "readonly": // mostly useless, used for value and no value
					$input[$f]['extra'] = ['NOTISNULL', 'ISNULL'];
					$input[$f]['view'] = [i18n('yes'), i18n('no')];
					$input[$f]['raw'] = true;
					$search_input .= $this->input_array($input[$f]); break;
				case "icons": $search_input .= $this->input_icons($input[$f]); break;
				case "country": $search_input .= $this->input_country($input[$f]); break;
				case "multicheck": $search_input .= $this->input_multicheck($input[$f]); break;
				case "multilookup": $search_input .= $this->input_multilookup($input[$f]); break;
				case "text": $search_input .= $this->input_raw_select($input[$f]); break;
				default:  $search_input .= "NO FILTERING FOR ".$f;
				}

			}
		foreach ($this->freebies as $f => $v) {
			$search_input .= "<input type=\"hidden\" id=\"i".$f."\" name=\"".$f."\" value=\"".$v."\"  />\n";
			}

		$search_input .= $this->in_searchform;
		$s_title = property_exists($this, "s_title") ? $this->s_title : i18n('search');
		$s_button = property_exists($this, "s_button") ? $this->s_button : "<button type='submit' name='_thiswords' value='1'><i class='fas fa-search fa-lg'></i> ".i18n('search')."</button>&nbsp;";

		// without table we need a selectbox to select a suitable sort-order
		if ($this->sort_select) {
			if ($this->sort_select_view) {$view = array_map('i18n', $this->sort_select_view);}
			else {$view = array_map('i18n', $this->sort_select);}
			$val = param('_ob') ? clean_var(param('_ob'), 'w') : 'score';
			$ob = ["me" => "_ob", "caption" => i18n('sort'), "type" => "array", "raw" => 1, "extra" => $this->sort_select, 'view' => $view, 'value' => $val];
			$ob = $this->expand_input($ob);
        	$search_input .= $this->input_array($ob);
			}

		if ($this->searchform) {
			$a = $this->sf_size;
			$b = 12 - $a;
			$this->searchform = "
<form name='searchform' action='{$this->action}' method='get' enctype='application/x-www-form-urlencoded'>
	<input type='hidden' name='sid' value='{$this->html['sid']}' />
	<input type='hidden' name='_id' value='{$this->myconf}' />
	<input type='hidden' name='_ob' value='$orderby' />
	<input type='hidden' name='_sb' value='$sortby' />
	<div class='clrfx tlform'>
	<div class='col w$a first'>
	$search_input
	</div>
	<div class='col w$b right'>
	<p>$s_button</p>
	$limitbox
	</div>
	</div>
</form>";
			}
		else {$this->searchform = "";} # instead of 0
		}

	private function get_fulltext() {
		global $db;
		$arg = $db->prepare("SHOW KEYS FROM `$this->table` WHERE index_type = 'FULLTEXT';");
		$arg->execute();
		$fulltext = array();
		while ($full = $arg->fetch(PDO::FETCH_ASSOC)) {
			array_push($fulltext, $full['Column_name']);
			}
		return $fulltext;
		}

	private function actions($id, $count) {
		$url = "{$this->action}?sid={$this->html['sid']}&amp;_id={$this->myconf}";
		$url .= "&amp;".http_build_query($this->q_arr, '', '&amp;');
		$str = "";
		if ($this->allow_box or $this->custom_box) {
			if (in_array($id, $this->no_del)) {$str = get_icon('square-ghost', i18n('op_not_pos')). "&nbsp;";}
			else {$str = "<input type='checkbox' name='rid[$count]' id='rid[$count]' value='$id' data-app='check_all' /><label for='rid[$count]'>&nbsp;</label>";}
			}
		if ($this->allow_edit) {
			if (in_array($id, $this->no_edit)) {$ed_icon = get_icon('noedit', '-')."&nbsp;";}
			else {
				$allow = true;
				if (!empty($this->edit_only)) {
					if (!in_array($id, $this->edit_only)) {$ed_icon = get_icon('noedit', '-')."&nbsp;"; $allow = false;}
					}
				if ($allow) {
					$f = $this->allow_edit;
					$temp = "$url&amp;todo=edit&amp;rid=$id";
					if (function_exists($f)){$temp = $f($temp, $this->temp);}
					$ed_icon = "<a href='$temp'>".get_icon('edit', i18n('edit'))."</a>&nbsp;";
					}
				}
			$str .= $ed_icon;
			}
		if ($this->allow_del) {
			if (in_array($id, $this->no_del)) {$str .= get_icon('nodelete', '-')."&nbsp;";}
			else {$str .= "<a href='$url&amp;todo=delete&amp;rid=$id'>".get_icon('delete', i18n('delete'))."</a>&nbsp;";}
			}
		if ($this->allow_something) {
			if (is_array($this->allow_something)) {$stg = $this->allow_something[0]; $ico = $this->allow_something[1]; $des = $this->allow_something[2];}
			else {$stg = $this->allow_something; $ico = 'png-'.$stg; $des = $stg;}
			$str .= "<a href='$url&amp;todo=_$stg&amp;rid=$id' data-app='$stg'>".get_icon($ico, i18n($des))."</a>";
			}
		return $str;
		}

	private function add_script() {
		$cript = $this->{'script'};
		$ln = "de"; # TODO
		# JQ Calendar
		if (array_key_exists('date', $cript)) {
			$this->scripts .= "<script src='/js/jQdate.js'></script><script>\$(function() {\$(\"[data-app='JQdate']\").datepick({'ln':'$ln'});});</script>\n";
			}
		if (array_key_exists('spin', $cript)) {
			$this->scripts .= "<script src='/js/jQspin.js'></script>
<script>
\$(document).ready(function(){\$(\"[data-app='spin']\").spinme();});
</script>\n";
}
		if (array_key_exists('colorpicker', $cript)) {
			$this->scripts .= "<script src='/js/jQcolorpicker.min.js'></script>
<script>
\$(document).ready(function(){\$(\"[data-app='colorpicker']\").colorpick();});
</script>\n";
			}
		# loading message
		if (array_key_exists('loading_mess', $cript)) {
			$this->scripts .= "<script>\$(document).ready(function () {\$('#site').doLoading({'loading': '".i18n('submit_data')."'});});</script>";
			}
		if (array_key_exists('collapse', $cript)) {
			$this->scripts .= "<script type=\"text/javascript\">\$(document).ready(function () {\$(\"[data-app='collapse']\").collapse();});</script>";
			}
		# autocomplete
		if (array_key_exists('aco', $cript)) {
			$this->scripts .= "<script src='/js/jQautocomplete.js'></script>";
			}
		# image assistant
		if (array_key_exists('img', $cript)) {
			$this->scripts .= "<script>\$(function(){\$(\"[data-app='load_img']\").assistant({'title':'".i18n('edit')."', 'sid': '{$this->html['sid']}', 'type': 'image', 'img': 'image'});});</script>\n";
			}
		# link assistant
		if (array_key_exists('file', $cript)) {
			$this->scripts .= "<script>\$(function(){\$(\"[data-app='load_link']\").assistant({'title':'".i18n('edit')."', 'sid': '{$this->html['sid']}', 'type': 'link', 'img': 'link'});});</script>\n";
			}
		# set link
		if (array_key_exists('set_link', $cript)) {
			$this->scripts .= "
<script>
	\$(document).ready(function () {\$(\"[data-app='set_link']\").css('cursor', 'pointer').click(function(){
		var val = \$(this).attr('data-value');
		var tid = \$(this).attr('data-target');
		var target = \$('#'+tid, parent.document);
		if (target.attr('id') === undefined) {target = $('#subform', parent.document).contents().find('#'+tid);}
		target.val(val);
		\$('#pp'+tid, parent.document).fadeOut('slow',function(){\$('.dlg').remove();});
		target.focus();
		});
	});
</script>\n";
			}
		# popup
		if (array_key_exists('popup', $cript)) {
			$me = $cript['popup'];
			$w = 500; $h = 300;
			if (is_array($me)) {
				$type = 'popupform';
				if (array_key_exists('w', $me)) {$w = $me['w'];}
				if (array_key_exists('h', $me)) {$h = $me['h'];}
				if (array_key_exists('t', $me)) {$t = $me['t'];}
				}
			else {$type = $me; $w = 500; $h = 300; $t = i18n('preview');}
			$this->scripts .= "<script>\$(document).ready(function () {\$('.$type').popLink({header: '$t', 'top': '10px', 'left': '10px', 'width': '$w', 'height': '$h'});});</script>\n";
			}

		#confirm leaving page
		if (array_key_exists('dontleave', $cript)) {
			$this->scripts .= <<<EOT
<script>
\$(document).ready(function () {\$('body').keydown(function(e){\$(document).dontleaveme(true)});});
\$(document).ready(function () {\$('select').change(function(){\$(document).dontleaveme(true)});});
\$(document).ready(function () {\$('form').on('submit', function(){\$(document).dontleaveme(false)});});
</script>
EOT;
			}

		# JQWYS
		if (array_key_exists('rte', $cript)) {
			global $con, $website;
			$objects = isset($website['css_generation']) ? 'yo-objects.js' : '';
			$objects = array_key_exists('jqwysobjects', $con) ? $con['jqwysobjects'] : $objects;
			if ($objects) {$objects = "objects: '$objects'";}
			$this->scripts .= <<<EOL
<script src="/js/jQwys4.js"></script>
<script>
\$(document).ready(function(){\$("#{$cript['rte']}").wysiwym({lang:"$ln",sid:"{$this->html['sid']}",config:"{$cript['rte_config']}",$objects})});
</script>
EOL;
			}

		#toggle flags
		if (array_key_exists('flag', $cript)) {
			$com = "";
			foreach ($cript['flag'] as $k=>$v) {
				$com .= $v."\n";
				}
			$this->scripts .= "\n<script>$com\n</script>\n";
			}
		# enhanced Selectbox
		if (array_key_exists('enhanSel', $cript)) {
			$me = $cript['enhanSel'];
			$opt = '';
			if (is_array($me)) {
				if (array_key_exists('width', $me)) {$opt .= "'width': '{$me['width']}',";}
				if (array_key_exists('img_w', $me)) {$opt .= "'img_w': {$me['img_w']},";}
				if (array_key_exists('img_h', $me)) {$opt .= "'img_h': {$me['img_h']},";}
				}
			if ($opt) {$opt = '{'.$opt.'}';}
			$this->scripts .= "<script>$(document).ready(function(){\$(\"[data-app='enhanSel']\").enhanSel($opt);});</script>\n";
			}

		# upload file helper
		if (array_key_exists('fupload', $cript)) {
			$this->scripts .= "<script>$(document).ready(function(){\$(\"[data-app='fupload']\").fupl();});</script>\n";
			}
		# smart input
		if (array_key_exists('smart', $cript)) {
			$size = $cript['smart'] < 15 ? $cript['smart'] : 15;
			$this->scripts .= "<script>$(document).ready(function(){\$(\"[data-smart]\").smartInput({'sid':\"{$this->html['sid']}\", 'script':\"{$this->action}\", 'size':\"$size\"});});</script>\n";
			}
		# counter textarea
		if (array_key_exists('counter', $cript)) {
			$this->scripts .= "<script>$(document).ready(function(){\$(\"[data-app='counter']\").textlimit({'text':\"<br>".i18n('chars_left')."\"});});</script>\n";
			}
		# model
		if (array_key_exists('foo', $cript)) {
			$this->scripts .= "<script></script>\n";
			}
		}

	private function sort_srcipts($t) {
		$d = [
			'table' => $t,
			'move_info' => i18n('move_info'),
			'moved' => i18n('moved'),
			'move' => i18n('move')
			];
		$c = parse_in('gui_sort_script', $d);
		return $c;
		}

	private function offsets($count) {
		$href = "{$this->action}?sid={$this->html['sid']}&amp;_id={$this->myconf}";
		$arr = $this->q_arr;
		unset($arr['_o']);
		$href .= "&amp;".http_build_query($arr, '', '&amp;');
		$offset = $this->offset;
		$offsets = ""; $limit = "";
		if ($count <= $this->q_limit) {
			$entr = $count == 1 ? i18n('entry') : i18n('entries');
			$offsets = "$count $entr";
			}
		else {
			$offsets = "$count ".i18n('entries')."&nbsp;";
			$before = $offset - $this->q_limit;
			$next = $offset + $this->q_limit;
			$nexto = ""; $beforeto = "";
			if ($before >= 0) {
				$beforeto = "<a href='$href&amp;_o=$before'>&larr;</a> ";
				}
			if ($next <= $count) {
				$nexto = " <a href='$href&amp;_o=$next'>&rarr;</a>";
				}
			$count = intval($count/$this->q_limit);
			$start = 0; $end = $count;
			if ($count > $this->q_limit2) {
				#show only hitlimit sites
				$start = intval((($offset/$this->q_limit) - ($this->q_limit2/2)));
				$end = intval((($offset/$this->q_limit) + ($this->q_limit2/2)));
				if ($start < 0) {$end = $end + abs($start); $start = 0;}
				if ($end > $count) {$start = $start - ($end - $count); $end = $count;}
				if ($start > 0) {$beforeto .= "<a href='$href'>0</a>... ";}
				if ($end < $count) {$nexto = " ...<a href='$href&amp;_o=".$count*$this->q_limit."'>$count</a>".$nexto;}
				}
			$offsets .= $beforeto;
			for ($i = $start; $i <= $end; $i++) {
				$ii = $i*$this->q_limit;
				if ($ii != $offset) {
					$offsets .= "<a href='$href&amp;_o=$ii'>$i</a>|";
					}
				else { $offsets.= "<strong>$i</strong>|";}
				}
			rtrim($offsets);
			$offsets .= $nexto;
			$limit = " limit $offset, $this->q_limit";
			}
		$this->offsetText = "<div class='offsets'>\n".$offsets."\n</div>\n";
		$this->query .= $limit;
		}

	private function pwd_check($v) {
		$val = $v['value'];
		if ($this->rid != "new") {
			global $db;
			$arg = $db->prepare("SELECT `{$v['me']}` FROM `{$this->table}` WHERE `{$this->primary}` = ?;");
			$arg->execute(array($this->rid));
			$data = $arg->fetch(PDO::FETCH_ASSOC);
			$placeholder = substr($data[$v['me']], 0, 12);
			if ($val != $placeholder){$val = yololo($val);}
			else {$val = $data[$v['me']];}
			}
		else {$val = yololo($val);}
		return $val;
		}

	private function multi_sync($v) {
		$val = '';
		$tags = param('real_'.$v['me']);
		$keys = array();
		if (is_array($tags)) {
			foreach($tags as $tag) {
				if (is_numeric($tag)) {array_push($keys, $tag);}
				else {
					global $db;
					$tag = clean_var($tag, 'w');
					$arg = $db->prepare("INSERT INTO `{$v['ltable']}` SET `{$v['lval']}` = ?;");
					$arg->execute(array($tag));
					array_push($keys, $db->lastInsertId($v['lid']));
					}
				}
			}
		return implode(',', $keys);
		}

	private function get_selection() {
		global $db;
		$hidden = $this->get_search_params();
		$names = ""; $ids = array();
		if (is_array($this->rid)) {$ids = $this->rid;}
		else {$ids[0] = $this->rid;}
		foreach($ids as $k=>$v) {
			$v = clean_var($v, "n");
			$query = "SELECT * FROM `$this->table` WHERE `{$this->primary}` = ?;";
			$arg = $db->prepare($query);
			$arg->execute(array($v));
			$result = $arg->fetch(PDO::FETCH_ASSOC);
			$name = $result[$this->human] ? $result[$this->human] : $result[$this->primary];
			$names .= $name.", ";
			$hidden .= "<input type='hidden' name='rid[$k]' value='$v' />\n";
			}
		$names = preg_replace("/\,\s$/", "", $names);
		$names = htmlspecialchars($names);
		return array($hidden, $names);
		}

	// checks if there is any record in the subtable
	private function check_sub($field) {
		global $db;
		if (!array_key_exists("subtable", $field)) {$field['subtable'] = $field['conf'];}
		$q = "SELECT `{$field['foreign']}` FROM `{$field['subtable']}` WHERE `{$field['foreign']}` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($this->rid));
		return $arg->rowCount();
		}

	// creates and updates junction table for n:n relation
	private function sync_junction($k, $v, $id) {
		global $db;
		$junction = $this->table."_junction_$k";
		// create table if not exists
		$q = "CREATE TABLE IF NOT EXISTS `$junction` (
			`id` BIGINT UNSIGNED  NOT NULL AUTO_INCREMENT,
			`id_$this->table` BIGINT UNSIGNED NOT NULL,
			`id_$k` BIGINT UNSIGNED NOT NULL,
			PRIMARY KEY ( `id` ),
			KEY ( `id_$this->table` ),
			KEY ( `id_$k` ))
			ENGINE=MyISAM DEFAULT CHARSET=utf8;";
		$arg = $db->prepare($q);
		$arg->execute();
		// delete existing relations
		$arg = $db->prepare("DELETE FROM `$junction` WHERE `id_$this->table` = ?;");
		$arg->execute(array($id));
		// update relations
		foreach ($v as $a) {
			$arg = $db->prepare("INSERT INTO `$junction` set `id_$this->table` = ?, `id_$k` = ?;");
			$arg->execute(array($id, $a));
			}
		}

	private function del_junction($k, $id) {
		global $db;
		$junction = $this->table."_junction_$k";
		// delete existing relations
		$arg = $db->prepare("DELETE FROM `$junction` WHERE `id_$this->table` = ?;");
		$arg->execute(array($id));
		}

	private function track_query($q) {
		global $con;
		$q = str_replace(["\r\n", "\n", "\r"], '\n', $q);
		$q = str_replace("\t", '\t', $q);
		$ln = date('Y-m-d H:i:s').": $q\n";
		file_put_contents("{$_SERVER['DOCUMENT_ROOT']}{$con['coco']}/lib/sql/track.sql", $ln, FILE_APPEND);
		}

	private function retaint_query($q, $taint) {
		$q = preg_replace_callback('/\?/', function($m) use (&$taint) {
			$a = array_shift($taint);
			if ($a) {$a = str_replace("'", "\'", $a);}
			return "'".$a."'";}, $q);
		return $q;
		}

	public function sanitize($inputs) {
		foreach ($inputs as $k=>$v){
			if (array_key_exists('value', $v)){
				if(!is_array($inputs[$k]['value'])) {
					$inputs[$k]['value'] = clean_var($inputs[$k]['value'], 'w');
					$inputs[$k]['value'] = htmlspecialchars($inputs[$k]['value']);
					}
				}
			}
		return $inputs;
		}

	}


?>
