<?php

 //Copyright (C) 1999-2015 by IMB Webdevelopment
 //
 // Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 // This program is free software; you can redistribute it and/or modify
 // it under the terms of the GNU General Public License as published by
 // the Free Software Foundation; either version 2 of the License, or
 // (at your option) any later version.
 //
 // This program is distributed in the hope that it will be useful,
 // but WITHOUT ANY WARRANTY; without even the implied warranty of
 // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 // GNU General Public License for more details.
 //
 // You should have received a copy of the GNU General Public License
 // along with this program; if not, write to the Free Software
 // Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 // MA 02110-1301, USA.

//  get and extend config
require_once ("lib/conf_inc.php");
// shared functions
require_once ("lib/share.php");
// gui package
require_once ("lib/gui.php");
// package to controll and view database-tables
require_once ("lib/access.php");
// functions of cms
require_once ("lib/cms.php");
// debug mode: display errors
if (isset($con['debug'])) {
	error_reporting(E_ALL);
	ini_set("display_errors", 1);
	}

// session
ini_set('session.cookie_lifetime', '1200');
ini_set('session.cookie_samesite', 'Strict');

session_name('coco');
session_start();
if (!isset($_SESSION['start'])) {$_SESSION['start'] = date('Y-m-d H:i:s');}

$con['version'] = chop(open_txt(basename(__DIR__).'/lib/version.txt'));
$con['coco'] = "/".basename(__DIR__);

/**
 * @var array data for the gui
 */
$html = [
	"title"			=> "Consentio CMS",
	"gui"			=> 1,
	"left"			=> " ",
	"content"		=> " ",
	"header"		=> "<h1>Consentio</h1>",
	"navigation"	=> " ",
	"footer"		=> " ",
	"scripts"		=> '',
	"con"			=> $con,
	"bubbles"		=> "",
	"feedback"		=> "",
	"popup"			=> "",
	"sid"			=> clean_var(param('sid'), "n"),
	"myurl"			=> basename(__FILE__),
	"dir"			=> $_SERVER['DOCUMENT_ROOT']
	];

/**
 * @var array $i18n for different languages
 */
$i18n = array();
/**
 * @var array $bubbles for help bubbles
 */
$bubbles = array();

// try to connect to db
try {
	$dns = $dba['db_driver'].":dbname=".$dba['database'].";host=".$dba['host'].";charset=utf8";
    $db = new PDO($dns, $dba['db_user'], $dba['db_pw']);
	}
catch (PDOException $e) {
    echo 'Connection failed: ' . $e->getMessage();
	exit;
	}

/**
 * @var array $user data of user
 */
$user = get_user($html['sid']);

if (!array_key_exists('name', $user)) {
	$html['feedback'] = array_key_exists('feedback', $user) ? $user['feedback'] : "";
	$html['user'] = $user;
	$html['user']['language'] = $con['ln'];
	$html = make_login_form($html);
	}
else {
	used_langs(); // check multilingual support
	$html['action'] = clean_var(param('_id'), "w");
	$html['sid'] = $user['sid'];
	if (param('scheme')) {$user['scheme'] = param('scheme');} // immediate change of skin
	$html['user'] = $user;
	$html = get_one_register($html);
	$website = read_settings(['group' => 'cms']);
	if ($user['helpme']) {$html['bubbles'] = bubbles($html['action']);}
	switch ($html['action']) {
		case "start": $html = overview($html); break;
		case "help": $html = help_us($html); break;
		case "ajax": $html = ajax($html); break;
		case "logout":
			$html = logout($html);
			unset($user['sid']);
			break;
		default:
			if (include_once ("plugins/{$html['plugin']}.php")) {
				// as class
				if (class_exists($html['plugin'])) {
					$myclass = new $html['plugin']();
					$html = $myclass->plugin($html);
					}
				// procedural
				else {$html = plugin($html);}
				}
			else {$html['content'] = say_mess(i18n('no_plugin').": ../plugins/{$html['plugin']}.php", i18n('error'), "error");}
			break;
		}
	}
$gui = new gui($html);
$output = $gui->generate();
echo $output;
$db = null;
?>
