<!DOCTYPE html>
<html>
<head>
<title>Evaluation</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="/css/yolololo.css" type="text/css" />
<link rel="stylesheet" href="/css/forkawesome-all.min.css" type="text/css" />
<link rel="stylesheet" href="/css/gui/style1.css" type="text/css" />
<script src="/js/jQuery.js"></script>
</head>

<body>
<div id="site">
<header class="clrfx">
<div class="grid clrfx">
<h1>Evaluate and Install Consentio CMS</h1>
</div>
</header>
<div id="content" class="grid clrfx">
<aside class="col w3">
	<div class="col row short_help">
	<h2><img src="/graphics/consentio.svg" title="Consentio Web Analytics" width="155" height="35"></h2>
	<p>This tool helps to install Consentio&nbsp;3.1xx and to set proper configurations in config_inc.php.</p>
	<ol>
		<li>Create a database with any tool you like.</li>
		<li>Open and edit config_inc.php with a text-editor.</li>
		<li>Follow these instructions.</li>
		<li>Reload this site after any alteration of configurations and settings.</li>
	</ol>
	</div>
</aside>
<main class="col w6">
<?php
require_once ("lib/conf_inc.php");
$version = file_get_contents('lib/version.txt');

$wrong = 0;
$read_dirs = ["css", "js", "co_icons", "co_icons/flags", "co_icons/48", "documents", "pictures", "pictures/cinemascope", "pictures/normal", "pictures/small", "pictures/square", "pictures/thumbs"];
$write_dirs = ["documents", "pictures", "pictures/cinemascope", "pictures/normal", "pictures/small", "pictures/square", "pictures/thumbs"];
$user = get_current_user();
$uid = getmyuid();
$gid = getmygid();
$wuser = getenv('APACHE_RUN_USER');
$wgroup = getenv('APACHE_RUN_GROUP');
$docroot = $_SERVER['DOCUMENT_ROOT'];
$cms_dir = realpath("..");
$coco = basename(__DIR__);

$inc = '<?php
// required libs for dynamic output
require_once ("'.$coco.'/lib/conf_inc.php");
require_once ("'.$coco.'/lib/share.php");
require_once ("'.$coco.'/lib/access.php");
require_once ("'.$coco.'/lib/cms.php");
$con["version"] = open_txt("'.$coco.'/lib/version.txt");
?>';

echo "<h2>Requirements</h2>";

#PHP 5.4.0
if (PHP_MAJOR_VERSION == 7 && PHP_MINOR_VERSION >= 3) {
	echo "<p>PHP Version: ".phpversion()." <span class='green'>OK</span></p>";
	}
else if (PHP_MAJOR_VERSION > 7) {
	echo "<p>PHP Version: ".phpversion()." <span class='green'>OK</span></p>";
	}
else {
	echo "<p>PHP Version: ".phpversion()." <span class='red'>PHP 7.4 or higher is required</span></p>";
	$wrong =1;
	}
if (phpversion('PDO')) {
	echo "<p>PHP Data Objects: ".phpversion('PDO')." <span class='green'>OK</span></p>";
	if (phpversion('pdo_mysql')) {
		echo "<p>PDO-MYSQL driver: ".phpversion('pdo_mysql')." <span class='green'>OK</span></p>";
		}
	else {echo "<p class='red'>PDO-MYSQL driver pdo_mysql is missing</p>";}
	}
else {echo "<p class='red'>PHP Data Objects: PDO is missing</p>"; $wrong =1;}

if (function_exists('gd_info')) {
	$gd = gd_info();
	echo "<p>Image Processing and GD: ".$gd['GD Version']." <span class='green'>OK</span></p>";
	}
else {echo "<p class='red'>Image Processing and GD: GD is missing</p>"; $wrong =1;}

echo "<h2>Configuration Consentio $version</h2>";
echo "<p>Host: <strong>".$_SERVER['HTTP_HOST']."</strong></p>";
echo "<p>Owner is <strong>$user ($uid)</strong>, Group: <strong>$gid</strong></p>";
echo "<p>Apache User: <strong>$wuser</strong>, Group: <strong>$wgroup</strong>";
echo "<p>Document Root: <strong>$docroot</strong></p>";
if ($docroot != $cms_dir) {echo "<p class='red'>Please install Consentio in Document Root.</p>";}
echo "<p>Consentio Path: <strong>".__DIR__."</strong>";
if (preg_match("/\/consentio/", __DIR__)) {echo "<br />You may rename the consentio directory for security reasons.</p>";}
else {echo "</p>";}
echo "<p>Default Language: <strong>".$con['ln']."</strong><br />If this is not the appreciated language set 'ln' in config_inc.php to the proper iso639-code of your language like 'en', 'fr' or 'es'.</p>";
echo "<p>Profile: <strong>".$con['profile']."</strong><br />Set 'profile' to 'cms' for Content Management or 'mvc' for Framework only.</p>";
echo "<h2>Permissions</h2>";
if (is_permitted_to($docroot, $wuser, $wgroup, 'w')) {
	echo "<p>$docroot is writeable: <span class='green'>OK</span></p>";
	write_file('inc.php', $inc);
	if (file_exists("$docroot/inc.php")) {echo "<p>Create inc.php: <span class='green'>OK</span></p>";}
	else {echo "<p>Create inc.php: <span class='red'>FAILED</span></p>"; $wrong =1;}
	}
else {
	echo "<p class='red'>$docroot must be writeable</p>";
	$wrong =1;
	}

if (is_permitted_to("$docroot/css", $wuser, $wgroup, 'w')) {
	echo "<p>$docroot/css is writeable: <span class='green'>OK</span></p>";
	}
else {
	echo "<p class='red'>Directory $docroot/css must be writeable</p>";
	$wrong =1;
	}

foreach ($read_dirs as $dir) {
		if (!is_permitted_to("$docroot/$dir", $wuser, $wgroup, 'r')) {echo "<p class='red'>Directory $docroot/$dir must be readable</p>"; $wrong =1;}
		}

echo "<h2>Database</h2>";

# try to connect to db
try {
	$dns = "mysql:dbname=".$dba['database'].";host=".$dba['host'];
  $db = new PDO($dns, $dba['db_user'], $dba['db_pw']);
	}
catch (PDOException $e) {
  echo "<p class='red'>Connection failed: ".$e->getMessage()."</p>";
	echo "<p>Configure {$dba['database']}, {$dba['db_user']}, {$dba['db_pw']} in lib/conf_inc.php</p>";
	$wrong =1;
	}
if ($db && $dba['database']) {
	echo "<p>Database: <span class='green'>OK</span></p>";
	$check = true;
	try {
		$arg = $db->prepare("SELECT `id` FROM `user` LIMIT 1;");
		$arg->execute();
		}
	catch (PDOException $e) {$check = false;}
	if (!$_GET['makedb']) {
		if (!$check) {
			echo "<p>Create TABLES now: <a href='evaluate.php?makedb=1' class='as_button'>Click here</a></p>";
			$wrong =1;
			}
		}
	else {
		$exec = "mysql --user={$dba['db_user']} --password={$dba['db_pw']} {$dba['database']} --default-character-set=utf8mb3 < ".__DIR__."/lib/sql/core.sql";
		$check = exec($exec);
		if (!$check) {echo "<p class='green'>Tables of core.sql have been created.</p>";}
		else {echo "<p>Create tables of core.sql</p> <span class='red'>FAILED</span></p>";}
		if ($con['profile'] != 'mvc') {
			$exec = "mysql --user={$dba['db_user']} --password={$dba['db_pw']} {$dba['database']} --default-character-set=utf8mb3 < ".__DIR__."/lib/sql/cms.sql";
			$check = exec($exec);
			if (!$check) {echo "<p class='green'>Tables of cms.sql have been created.</p>";}
			else {echo "<p>Create tables of cms.sql</p> <span class='red'>FAILED</span></p>";}
			}
		}
	}
else {
    echo "<p class='red'>Configure your database in lib/conf_inc.php</p>";
	$wrong =1;
	}
echo "<h2>Finish</h2>";

if (!$wrong) {
	$check = $_POST['makeuser'] ? true : false;
	if ($check) {
		$check = $_POST['makeuser'] ? true : false;
		}
	if (!$check) {
		echo "<div class=\"tlform\">
<form action=\"evaluate.php\" id=\"itable\" name=\"table\" method=\"post\" enctype=\"multipart/form-data\" autocomplete=\"off\">
		<input type=\"hidden\" id=\"i_id\" name=\"makeuser\" value=\"1\">
<div class=\"row clrfx \" id=\"rowuser\">
<div class=\"col w3 first label variant \">
<label for=\"iuser\">Benutzer</label>&nbsp;
</div>
<div class=\"col w9 last\"><input type=\"text\" class=\"text loose\" id=\"iuser\" name=\"user\" value=\"\" size=\"20\" autofocus=\"autofocus\" placeholder=\"Your Username\" required autocomplete=\"off\">&nbsp;</div>
</div>
<div class=\"row clrfx \" id=\"rowpwd\">
<div class=\"col w3 first label variant \">
<label for=\"ipwd\">Passwort</label><br>Minimum 8 characters, one capital letter
</div>
<div class=\"col w9 last\">
<input type=\"password\" class=\"text loose\" id=\"ipwd\" placeholder=\"Your Password\" name=\"pwd\" value=\"\" size=\"20\" required autocomplete=\"off\"><br>
<input type=\"password\" class=\"text loose\" id=\"iccpwd\" placeholder=\"Retype Password\" name=\"ccpwd\" value=\"\" size=\"20\" required autocomplete=\"off\">
<script src='/js/jQpwdCheck.js'></script>
<script type='text/javascript'>$(document).ready(function () {\$('#itable').pwdCheck({'minchars': 8, 'digits': 0, 'field': 'ipwd', 'cmp' : 'iccpwd'});});</script>
</div>
</div>

<div class=\"variant buttons\"><button type=\"submit\" name=\"login\" value=\"1\"><i class=\"fas fa-sign-in-alt fa-lg\"></i> Create a maintainance-user</button>&nbsp;</div>
</form>

</div>";
		}
	else {
		$p = $_POST['pwd'] ? $_POST['pwd'] : 'consentio';
		$pp = password_hash($p, PASSWORD_BCRYPT, ['cost' => 12]);
		$u = $_POST['user'] ? $_POST['user'] :"Startuser";
		$arg = $db->prepare("UPDATE `user` SET `name` = ?, `pwd` = ? WHERE `id` = 1;");
		$arg->execute(array($u, $pp));
		echo "<h3 class='green'>Congratulations</h3>";
		echo "<p>Consentio is ready to use.</p>";
		echo "<p>Your username is <strong>$u</strong><br />Your password is  <strong>$p</strong><p>";
		echo "<p><a href='index.php' class='as_button' target='_blank'>Login</a> (opens in new window)</p>";
		echo "<p class='red'>After the first login this script will be removed from your server for security reasons.<p>";
		}
	}
else {
	echo "<p class='red'>Your configuration is not ready to proceed.</p>";
	}
$db = null;

function write_file($f, $c) {
	global $docroot;
	$html = fopen("$docroot/$f", 'w');
	fwrite($html, $c);
	fclose($html);
	}

function is_permitted_to($f, $u, $g, $t) {
	$val = ['r' => 0, 'w' => 0];
	$ow = posix_getpwuid(fileowner($f));
	$gr = posix_getgrgid(filegroup($f));
	$perm = substr(decoct(fileperms($f)), -4);
	$p = 0;
	if ($u == $ow['name']) {$p = substr($perm,1,1);}
	elseif ($g == $gr['name']) {$p = substr($perm,2,1);}
	switch ($p){
		case 2:
		case 3: $val['w'] = 1; break;
		case 4:
		case 5: $val['r'] = 1; break;
		case 6:
		case 7: $val['r'] = 1; $val['w'] = 1; break;
		}
	return $val[$t];
	}
?>

</main>
<aside class="col w3">
	<ul class='menue'>
		<li><a href='evaluate.php'><i class="fas fa-sync fa-5x" title='reload'></i><br />Reload</a></li>
	</ul>
</aside>
</div>
<div class="grid"><p></p><a href="https://www.consentio.at" target="_blank">Consentio</a></p></div>
</div>
</body>
