<?php
# @Author: Rainer Imb <consentio>
# @Date:   2018-08-25 01:40:07
# @Email:  imb@consentio.at
# @Project: consentio mccurdy
# @Filename: adlog.php
# @Last modified by:   consentio
# @Last modified time: 2023-09-08T12:11:45+02:00
# @License: GPL 2.0


error_reporting(E_ALL);
ini_set("display_errors", 1);

require_once ("lib/conf_inc.php");
require_once ("lib/share.php");

try {
	$dns = $dba['db_driver'].":dbname=".$dba['database'].";host=".$dba['host'].";charset=utf8";
    $db = new PDO($dns, $dba['db_user'], $dba['db_pw']);
	}
catch (PDOException $e) {exit;}

$mobile = 480; // pixel width mobile device
$jquery = '';
$log = []; $i = 0;

if (param('_c')) {
	$data = ollie(param('_c'));
	if (array_key_exists(2, $data)) {
		$log[0] = ['campaign' => $data[1], 'id' => $data[0], 'click' => 1];
		header("Location: {$data[2]}");
		}
	else{$log = [];}
	}

else {
	list($sw, $sh) = explode('-', clean_var(param('sc'), 'n'));
	$campaigns = get_campaigns();
	//var_dump($campaigns);
	$used = [];
	foreach ($_GET as $k=>$v) {
		if (preg_match("/^banner/", $k)) {
			$match = false;
			$id = preg_replace("/^banner-/", '', $k);
			list($w, $h, $t) = explode(',', $v);
			//if ($sw <= $mobile && $h > $sh*0.667) {$h = $sh*0.667;} // not higher than 2/3 of screen for mobile
			// best guess
			foreach ($campaigns as $a=>$c) {
				if (!in_array($c['campaign'], $used)) {if ($c['type']	== $t && $c['width'] <= $w && $c['height'] <= $h) {$match = $a;}}
				}
			// something that fits
			if ($match === false) {
				foreach ($campaigns as $a=>$c) {
					if (!in_array($c['campaign'], $used)) {if ($c['width'] <= $w) {$match = $a;}}
					}
				}
			if ($match !== false) {
				$banner = htmltag('img', "src=\"/pictures/{$campaigns[$match]['picture']}\" title=\"{$campaigns[$match]['name']}\"", '');
				$target = preg_match("/^https?/", $campaigns[$match]['url']) ? " target=\"_blank\"" : ''; // self-promotion
				$link = stan([$campaigns[$match]['id'], $campaigns[$match]['campaign'], $campaigns[$match]['url']]);
				//error_log("{$campaigns[$match]['url']}");
				$link = "/".basename(__DIR__).'/adlog.php?_c='.$link;
				$banner = htmltag('a',  "href=\"$link\"$target", $banner);
				array_push($used, $campaigns[$match]['campaign']);
				$jquery .= "\$('#$k').append('$banner');";
				$campaigns[$match]['click'] = 0;
				$log[$i] = $campaigns[$match]; $i++;
				}
			// nothing found that fits
			else {$jquery .= "\$('#$k').remove();";}
			}
		}
	}

if ($log) {log_campaigns($log);}

$db = null;
header("Content-type:application/javascript");
echo $jquery;

function get_campaigns() {
	global $db;
	$arr = [];
	$q = "SELECT  `banner`.`url`, `picture`, `name`, `campaign`, `width`, `height`, `type`, `creatives`.`id` FROM `banner` LEFT JOIN (`creatives`) ON (`banner`.`id` = `creatives`.`campaign`) WHERE `hold` <> 'on' AND `until` >= ? AND `from` <= ? ORDER BY RAND();";
	$arg = $db->prepare($q);
	$arg->execute(array(date('Y-m-d'), date('Y-m-d')));
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {array_push($arr, $data);}
	return $arr;
	}

function log_campaigns($l) {
	global $db;
	$date = explode('-', date('Y-m-d-H'));
	foreach ($l as $u) {
		$arg = $db->prepare("INSERT INTO `banner_stats` SET `year` = ?, `month` = ?, `day` = ?, `hour` = ?, `campaign` = ?, `creative` = ?, `click` = ?");
		$v = array_merge($date, [$u['campaign'], $u['id'], $u['click']]);
		$arg->execute($v);
		}
	}
?>
